package com.google.api.generator.gapic.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Service extends Service {

  private final String name;

  private final String defaultHost;

  private final ImmutableList<String> oauthScopes;

  private final String pakkage;

  private final String protoPakkage;

  private final String originalJavaPackage;

  private final String overriddenName;

  private final boolean isDeprecated;

  private final ImmutableList<Method> methods;

  @Nullable
  private final String description;

  private AutoValue_Service(
      String name,
      String defaultHost,
      ImmutableList<String> oauthScopes,
      String pakkage,
      String protoPakkage,
      String originalJavaPackage,
      String overriddenName,
      boolean isDeprecated,
      ImmutableList<Method> methods,
      @Nullable String description) {
    this.name = name;
    this.defaultHost = defaultHost;
    this.oauthScopes = oauthScopes;
    this.pakkage = pakkage;
    this.protoPakkage = protoPakkage;
    this.originalJavaPackage = originalJavaPackage;
    this.overriddenName = overriddenName;
    this.isDeprecated = isDeprecated;
    this.methods = methods;
    this.description = description;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String defaultHost() {
    return defaultHost;
  }

  @Override
  public ImmutableList<String> oauthScopes() {
    return oauthScopes;
  }

  @Override
  public String pakkage() {
    return pakkage;
  }

  @Override
  public String protoPakkage() {
    return protoPakkage;
  }

  @Override
  public String originalJavaPackage() {
    return originalJavaPackage;
  }

  @Override
  public String overriddenName() {
    return overriddenName;
  }

  @Override
  public boolean isDeprecated() {
    return isDeprecated;
  }

  @Override
  public ImmutableList<Method> methods() {
    return methods;
  }

  @Nullable
  @Override
  public String description() {
    return description;
  }

  @Override
  public String toString() {
    return "Service{"
        + "name=" + name + ", "
        + "defaultHost=" + defaultHost + ", "
        + "oauthScopes=" + oauthScopes + ", "
        + "pakkage=" + pakkage + ", "
        + "protoPakkage=" + protoPakkage + ", "
        + "originalJavaPackage=" + originalJavaPackage + ", "
        + "overriddenName=" + overriddenName + ", "
        + "isDeprecated=" + isDeprecated + ", "
        + "methods=" + methods + ", "
        + "description=" + description
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Service) {
      Service that = (Service) o;
      return this.name.equals(that.name())
          && this.defaultHost.equals(that.defaultHost())
          && this.oauthScopes.equals(that.oauthScopes())
          && this.pakkage.equals(that.pakkage())
          && this.protoPakkage.equals(that.protoPakkage())
          && this.originalJavaPackage.equals(that.originalJavaPackage())
          && this.overriddenName.equals(that.overriddenName())
          && this.isDeprecated == that.isDeprecated()
          && this.methods.equals(that.methods())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= defaultHost.hashCode();
    h$ *= 1000003;
    h$ ^= oauthScopes.hashCode();
    h$ *= 1000003;
    h$ ^= pakkage.hashCode();
    h$ *= 1000003;
    h$ ^= protoPakkage.hashCode();
    h$ *= 1000003;
    h$ ^= originalJavaPackage.hashCode();
    h$ *= 1000003;
    h$ ^= overriddenName.hashCode();
    h$ *= 1000003;
    h$ ^= isDeprecated ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= methods.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    return h$;
  }

  @Override
  public Service.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Service.Builder {
    private String name;
    private String defaultHost;
    private ImmutableList<String> oauthScopes;
    private String pakkage;
    private String protoPakkage;
    private String originalJavaPackage;
    private String overriddenName;
    private boolean isDeprecated;
    private ImmutableList<Method> methods;
    private String description;
    private byte set$0;
    Builder() {
    }
    private Builder(Service source) {
      this.name = source.name();
      this.defaultHost = source.defaultHost();
      this.oauthScopes = source.oauthScopes();
      this.pakkage = source.pakkage();
      this.protoPakkage = source.protoPakkage();
      this.originalJavaPackage = source.originalJavaPackage();
      this.overriddenName = source.overriddenName();
      this.isDeprecated = source.isDeprecated();
      this.methods = source.methods();
      this.description = source.description();
      set$0 = (byte) 1;
    }
    @Override
    public Service.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public Service.Builder setDefaultHost(String defaultHost) {
      if (defaultHost == null) {
        throw new NullPointerException("Null defaultHost");
      }
      this.defaultHost = defaultHost;
      return this;
    }
    @Override
    public Service.Builder setOauthScopes(List<String> oauthScopes) {
      this.oauthScopes = ImmutableList.copyOf(oauthScopes);
      return this;
    }
    @Override
    public Service.Builder setPakkage(String pakkage) {
      if (pakkage == null) {
        throw new NullPointerException("Null pakkage");
      }
      this.pakkage = pakkage;
      return this;
    }
    @Override
    public Service.Builder setProtoPakkage(String protoPakkage) {
      if (protoPakkage == null) {
        throw new NullPointerException("Null protoPakkage");
      }
      this.protoPakkage = protoPakkage;
      return this;
    }
    @Override
    public Service.Builder setOriginalJavaPackage(String originalJavaPackage) {
      if (originalJavaPackage == null) {
        throw new NullPointerException("Null originalJavaPackage");
      }
      this.originalJavaPackage = originalJavaPackage;
      return this;
    }
    @Override
    public Service.Builder setOverriddenName(String overriddenName) {
      if (overriddenName == null) {
        throw new NullPointerException("Null overriddenName");
      }
      this.overriddenName = overriddenName;
      return this;
    }
    @Override
    public Service.Builder setIsDeprecated(boolean isDeprecated) {
      this.isDeprecated = isDeprecated;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public Service.Builder setMethods(List<Method> methods) {
      this.methods = ImmutableList.copyOf(methods);
      return this;
    }
    @Override
    public Service.Builder setDescription(String description) {
      this.description = description;
      return this;
    }
    @Override
    public Service build() {
      if (set$0 != 1
          || this.name == null
          || this.defaultHost == null
          || this.oauthScopes == null
          || this.pakkage == null
          || this.protoPakkage == null
          || this.originalJavaPackage == null
          || this.overriddenName == null
          || this.methods == null) {
        StringBuilder missing = new StringBuilder();
        if (this.name == null) {
          missing.append(" name");
        }
        if (this.defaultHost == null) {
          missing.append(" defaultHost");
        }
        if (this.oauthScopes == null) {
          missing.append(" oauthScopes");
        }
        if (this.pakkage == null) {
          missing.append(" pakkage");
        }
        if (this.protoPakkage == null) {
          missing.append(" protoPakkage");
        }
        if (this.originalJavaPackage == null) {
          missing.append(" originalJavaPackage");
        }
        if (this.overriddenName == null) {
          missing.append(" overriddenName");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" isDeprecated");
        }
        if (this.methods == null) {
          missing.append(" methods");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Service(
          this.name,
          this.defaultHost,
          this.oauthScopes,
          this.pakkage,
          this.protoPakkage,
          this.originalJavaPackage,
          this.overriddenName,
          this.isDeprecated,
          this.methods,
          this.description);
    }
  }

}
