/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.OutlierDetectionLoadBalancer;
import io.grpc.xds.AddressFilter;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClusterImplLoadBalancerProvider;
import io.grpc.xds.ClusterResolverLoadBalancerProvider;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.Locality;
import io.grpc.xds.PriorityLoadBalancerProvider;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsEndpointResource;
import io.grpc.xds.XdsLogger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ClusterResolverLoadBalancer
extends LoadBalancer {
    private static final Locality LOGICAL_DNS_CLUSTER_LOCALITY = Locality.create("", "", "");
    private final XdsLogger logger;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final LoadBalancerRegistry lbRegistry;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final GracefulSwitchLoadBalancer delegate;
    private ObjectPool<XdsClient> xdsClientPool;
    private XdsClient xdsClient;
    private ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;

    ClusterResolverLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), new ExponentialBackoffPolicy.Provider());
    }

    @VisibleForTesting
    ClusterResolverLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, BackoffPolicy.Provider backoffPolicyProvider) {
        this.lbRegistry = Preconditions.checkNotNull(lbRegistry, "lbRegistry");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.delegate = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate("cluster-resolver-lb", helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ClusterResolverLoadBalancerProvider.ClusterResolverConfig config;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = resolvedAddresses.getAttributes().get(InternalXdsAttributes.XDS_CLIENT_POOL);
            this.xdsClient = this.xdsClientPool.getObject();
        }
        if (!Objects.equals(this.config, config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig())) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Config: {0}", config);
            this.delegate.switchTo(new ClusterResolverLbStateFactory());
            this.config = config;
            this.delegate.handleResolvedAddresses(resolvedAddresses);
        }
        return Status.OK;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.delegate.handleNameResolutionError(error);
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.delegate.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject(this.xdsClient);
        }
    }

    private static PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig generateDnsBasedPriorityChildConfig(String cluster, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, LoadBalancerRegistry lbRegistry, List<Endpoints.DropOverload> dropOverloads) {
        ServiceConfigUtil.PolicySelection endpointLbPolicy = new ServiceConfigUtil.PolicySelection(lbRegistry.getProvider("pick_first"), null);
        ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, null, lrsServerInfo, maxConcurrentRequests, dropOverloads, endpointLbPolicy, tlsContext);
        LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
        ServiceConfigUtil.PolicySelection clusterImplPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, clusterImplConfig);
        return new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(clusterImplPolicy, false);
    }

    private static Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> generateEdsBasedPriorityChildConfigs(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, @Nullable EnvoyServerProtoData.OutlierDetection outlierDetection, ServiceConfigUtil.PolicySelection endpointLbPolicy, LoadBalancerRegistry lbRegistry, Map<String, Map<Locality, Integer>> prioritizedLocalityWeights, List<Endpoints.DropOverload> dropOverloads) {
        HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs = new HashMap<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig>();
        for (String priority : prioritizedLocalityWeights.keySet()) {
            ClusterImplLoadBalancerProvider.ClusterImplConfig clusterImplConfig = new ClusterImplLoadBalancerProvider.ClusterImplConfig(cluster, edsServiceName, lrsServerInfo, maxConcurrentRequests, dropOverloads, endpointLbPolicy, tlsContext);
            LoadBalancerProvider clusterImplLbProvider = lbRegistry.getProvider("cluster_impl_experimental");
            ServiceConfigUtil.PolicySelection priorityChildPolicy = new ServiceConfigUtil.PolicySelection(clusterImplLbProvider, clusterImplConfig);
            if (outlierDetection != null) {
                LoadBalancerProvider outlierDetectionProvider = lbRegistry.getProvider("outlier_detection_experimental");
                priorityChildPolicy = new ServiceConfigUtil.PolicySelection(outlierDetectionProvider, ClusterResolverLoadBalancer.buildOutlierDetectionLbConfig(outlierDetection, priorityChildPolicy));
            }
            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = new PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig(priorityChildPolicy, true);
            configs.put(priority, priorityChildConfig);
        }
        return configs;
    }

    private static OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig buildOutlierDetectionLbConfig(EnvoyServerProtoData.OutlierDetection outlierDetection, ServiceConfigUtil.PolicySelection childPolicy) {
        EnvoyServerProtoData.FailurePercentageEjection failurePercentage;
        EnvoyServerProtoData.SuccessRateEjection successRate;
        OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder configBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.Builder();
        configBuilder.setChildPolicy(childPolicy);
        if (outlierDetection.intervalNanos() != null) {
            configBuilder.setIntervalNanos(outlierDetection.intervalNanos());
        }
        if (outlierDetection.baseEjectionTimeNanos() != null) {
            configBuilder.setBaseEjectionTimeNanos(outlierDetection.baseEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionTimeNanos() != null) {
            configBuilder.setMaxEjectionTimeNanos(outlierDetection.maxEjectionTimeNanos());
        }
        if (outlierDetection.maxEjectionPercent() != null) {
            configBuilder.setMaxEjectionPercent(outlierDetection.maxEjectionPercent());
        }
        if ((successRate = outlierDetection.successRateEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder successRateConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.SuccessRateEjection.Builder();
            if (successRate.stdevFactor() != null) {
                successRateConfigBuilder.setStdevFactor(successRate.stdevFactor());
            }
            if (successRate.enforcementPercentage() != null) {
                successRateConfigBuilder.setEnforcementPercentage(successRate.enforcementPercentage());
            }
            if (successRate.minimumHosts() != null) {
                successRateConfigBuilder.setMinimumHosts(successRate.minimumHosts());
            }
            if (successRate.requestVolume() != null) {
                successRateConfigBuilder.setRequestVolume(successRate.requestVolume());
            }
            configBuilder.setSuccessRateEjection(successRateConfigBuilder.build());
        }
        if ((failurePercentage = outlierDetection.failurePercentageEjection()) != null) {
            OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder failurePercentageConfigBuilder = new OutlierDetectionLoadBalancer.OutlierDetectionLoadBalancerConfig.FailurePercentageEjection.Builder();
            if (failurePercentage.threshold() != null) {
                failurePercentageConfigBuilder.setThreshold(failurePercentage.threshold());
            }
            if (failurePercentage.enforcementPercentage() != null) {
                failurePercentageConfigBuilder.setEnforcementPercentage(failurePercentage.enforcementPercentage());
            }
            if (failurePercentage.minimumHosts() != null) {
                failurePercentageConfigBuilder.setMinimumHosts(failurePercentage.minimumHosts());
            }
            if (failurePercentage.requestVolume() != null) {
                failurePercentageConfigBuilder.setRequestVolume(failurePercentage.requestVolume());
            }
            configBuilder.setFailurePercentageEjection(failurePercentageConfigBuilder.build());
        }
        return configBuilder.build();
    }

    private static String priorityName(String cluster, int priority) {
        return cluster + "[child" + priority + "]";
    }

    private static String localityName(Locality locality) {
        return locality.toString();
    }

    private static class ClusterResolutionResult {
        private final List<EquivalentAddressGroup> addresses;
        private final Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityChildConfigs;
        private final List<String> priorities;

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, String priority, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig config) {
            this(addresses, Collections.singletonMap(priority, config), Collections.singletonList(priority));
        }

        ClusterResolutionResult(List<EquivalentAddressGroup> addresses, Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> configs, List<String> priorities) {
            this.addresses = addresses;
            this.priorityChildConfigs = configs;
            this.priorities = priorities;
        }
    }

    private final class ClusterResolverLbState
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private final List<String> clusters = new ArrayList<String>();
        private final Map<String, ClusterState> clusterStates = new HashMap<String, ClusterState>();
        private ServiceConfigUtil.PolicySelection endpointLbPolicy;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private LoadBalancer childLb;

        ClusterResolverLbState(LoadBalancer.Helper helper) {
            this.helper = new RefreshableHelper(Preconditions.checkNotNull(helper, "helper"));
            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "New ClusterResolverLbState");
        }

        @Override
        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.resolvedAddresses = resolvedAddresses;
            ClusterResolverLoadBalancerProvider.ClusterResolverConfig config = (ClusterResolverLoadBalancerProvider.ClusterResolverConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            this.endpointLbPolicy = config.lbPolicy;
            for (ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism instance : config.discoveryMechanisms) {
                this.clusters.add(instance.cluster);
                ClusterState state = instance.type == ClusterResolverLoadBalancerProvider.ClusterResolverConfig.DiscoveryMechanism.Type.EDS ? new EdsClusterState(instance.cluster, instance.edsServiceName, instance.lrsServerInfo, instance.maxConcurrentRequests, instance.tlsContext, instance.outlierDetection) : new LogicalDnsClusterState(instance.cluster, instance.dnsHostName, instance.lrsServerInfo, instance.maxConcurrentRequests, instance.tlsContext);
                this.clusterStates.put(instance.cluster, state);
                state.start();
            }
            return Status.OK;
        }

        @Override
        public void handleNameResolutionError(Status error) {
            if (this.childLb != null) {
                this.childLb.handleNameResolutionError(error);
            } else {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
            }
        }

        @Override
        public void shutdown() {
            for (ClusterState state : this.clusterStates.values()) {
                state.shutdown();
            }
            if (this.childLb != null) {
                this.childLb.shutdown();
            }
        }

        private void handleEndpointResourceUpdate() {
            ArrayList addresses = new ArrayList();
            HashMap priorityChildConfigs = new HashMap();
            ArrayList priorities = new ArrayList();
            Status endpointNotFound = Status.OK;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (!state.resolved && state.status.isOk()) {
                    return;
                }
                if (state.result != null) {
                    addresses.addAll(state.result.addresses);
                    priorityChildConfigs.putAll(state.result.priorityChildConfigs);
                    priorities.addAll(state.result.priorities);
                    continue;
                }
                endpointNotFound = state.status;
            }
            if (addresses.isEmpty()) {
                endpointNotFound = endpointNotFound.isOk() ? Status.UNAVAILABLE.withDescription("No usable endpoint from cluster(s): " + this.clusters) : Status.UNAVAILABLE.withCause(endpointNotFound.getCause()).withDescription(endpointNotFound.getDescription());
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(endpointNotFound)));
                if (this.childLb != null) {
                    this.childLb.shutdown();
                    this.childLb = null;
                }
                return;
            }
            PriorityLoadBalancerProvider.PriorityLbConfig childConfig = new PriorityLoadBalancerProvider.PriorityLbConfig(Collections.unmodifiableMap(priorityChildConfigs), Collections.unmodifiableList(priorities));
            if (this.childLb == null) {
                this.childLb = ClusterResolverLoadBalancer.this.lbRegistry.getProvider("priority_experimental").newLoadBalancer(this.helper);
            }
            this.childLb.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(childConfig).setAddresses(Collections.unmodifiableList(addresses)).build());
        }

        private void handleEndpointResolutionError() {
            boolean allInError = true;
            Status error = null;
            for (String cluster : this.clusters) {
                ClusterState state = this.clusterStates.get(cluster);
                if (state.status.isOk()) {
                    allInError = false;
                    continue;
                }
                error = state.status;
            }
            if (allInError) {
                if (this.childLb != null) {
                    this.childLb.handleNameResolutionError(error);
                } else {
                    this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
                }
            }
        }

        private final class LogicalDnsClusterState
        extends ClusterState {
            private final String dnsHostName;
            private final NameResolver.Factory nameResolverFactory;
            private final NameResolver.Args nameResolverArgs;
            private NameResolver resolver;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private SynchronizationContext.ScheduledHandle scheduledRefresh;

            private LogicalDnsClusterState(String name, @Nullable String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                super(name, lrsServerInfo, maxConcurrentRequests, tlsContext, null);
                this.dnsHostName = Preconditions.checkNotNull(dnsHostName, "dnsHostName");
                this.nameResolverFactory = Preconditions.checkNotNull(ClusterResolverLbState.this.helper.getNameResolverRegistry().asFactory(), "nameResolverFactory");
                this.nameResolverArgs = Preconditions.checkNotNull(ClusterResolverLbState.this.helper.getNameResolverArgs(), "nameResolverArgs");
            }

            @Override
            void start() {
                URI uri;
                try {
                    uri = new URI("dns", "", "/" + this.dnsHostName, null);
                }
                catch (URISyntaxException e) {
                    this.status = Status.INTERNAL.withDescription("Bug, invalid URI creation: " + this.dnsHostName).withCause(e);
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver = this.nameResolverFactory.newNameResolver(uri, this.nameResolverArgs);
                if (this.resolver == null) {
                    this.status = Status.INTERNAL.withDescription("Xds cluster resolver lb for logical DNS cluster [" + this.name + "] cannot find DNS resolver with uri:" + uri);
                    ClusterResolverLbState.this.handleEndpointResolutionError();
                    return;
                }
                this.resolver.start(new NameResolverListener());
            }

            void refresh() {
                if (this.resolver == null) {
                    return;
                }
                this.cancelBackoff();
                this.resolver.refresh();
            }

            @Override
            void shutdown() {
                super.shutdown();
                if (this.resolver != null) {
                    this.resolver.shutdown();
                }
                this.cancelBackoff();
            }

            private void cancelBackoff() {
                if (this.scheduledRefresh != null) {
                    this.scheduledRefresh.cancel();
                    this.scheduledRefresh = null;
                    this.backoffPolicy = null;
                }
            }

            private class NameResolverListener
            extends NameResolver.Listener2 {
                private NameResolverListener() {
                }

                @Override
                public void onResult(final NameResolver.ResolutionResult resolutionResult) {
                    class NameResolved
                    implements Runnable {
                        NameResolved() {
                        }

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.backoffPolicy = null;
                            String priorityName = ClusterResolverLoadBalancer.priorityName(LogicalDnsClusterState.this.name, 0);
                            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                            for (EquivalentAddressGroup eag : resolutionResult.getAddresses()) {
                                Attributes attr = eag.getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_LOCALITY, LOGICAL_DNS_CLUSTER_LOCALITY).build();
                                eag = new EquivalentAddressGroup(eag.getAddresses(), attr);
                                eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, LOGICAL_DNS_CLUSTER_LOCALITY.toString()));
                                addresses.add(eag);
                            }
                            PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig priorityChildConfig = ClusterResolverLoadBalancer.generateDnsBasedPriorityChildConfig(LogicalDnsClusterState.this.name, LogicalDnsClusterState.this.lrsServerInfo, LogicalDnsClusterState.this.maxConcurrentRequests, LogicalDnsClusterState.this.tlsContext, ClusterResolverLoadBalancer.this.lbRegistry, Collections.emptyList());
                            LogicalDnsClusterState.this.status = Status.OK;
                            LogicalDnsClusterState.this.resolved = true;
                            LogicalDnsClusterState.this.result = new ClusterResolutionResult(addresses, priorityName, priorityChildConfig);
                            ClusterResolverLbState.this.handleEndpointResourceUpdate();
                        }
                    }
                    ClusterResolverLoadBalancer.this.syncContext.execute(new NameResolved());
                }

                @Override
                public void onError(final Status error) {
                    ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (LogicalDnsClusterState.this.shutdown) {
                                return;
                            }
                            LogicalDnsClusterState.this.status = error;
                            if (!LogicalDnsClusterState.this.resolved) {
                                LogicalDnsClusterState.this.resolved = true;
                                ClusterResolverLbState.this.handleEndpointResourceUpdate();
                            } else {
                                ClusterResolverLbState.this.handleEndpointResolutionError();
                            }
                            if (LogicalDnsClusterState.this.scheduledRefresh != null && LogicalDnsClusterState.this.scheduledRefresh.isPending()) {
                                return;
                            }
                            if (LogicalDnsClusterState.this.backoffPolicy == null) {
                                LogicalDnsClusterState.this.backoffPolicy = ClusterResolverLoadBalancer.this.backoffPolicyProvider.get();
                            }
                            long delayNanos = LogicalDnsClusterState.this.backoffPolicy.nextBackoffNanos();
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Logical DNS resolver for cluster {0} encountered name resolution error: {1}, scheduling DNS resolution backoff for {2} ns", LogicalDnsClusterState.this.name, error, delayNanos);
                            LogicalDnsClusterState.this.scheduledRefresh = ClusterResolverLoadBalancer.this.syncContext.schedule(new DelayedNameResolverRefresh(), delayNanos, TimeUnit.NANOSECONDS, ClusterResolverLoadBalancer.this.timeService);
                        }
                    });
                }
            }

            private class DelayedNameResolverRefresh
            implements Runnable {
                private DelayedNameResolverRefresh() {
                }

                @Override
                public void run() {
                    LogicalDnsClusterState.this.scheduledRefresh = null;
                    if (!LogicalDnsClusterState.this.shutdown) {
                        LogicalDnsClusterState.this.resolver.refresh();
                    }
                }
            }
        }

        private final class EdsClusterState
        extends ClusterState
        implements XdsClient.ResourceWatcher<XdsEndpointResource.EdsUpdate> {
            @Nullable
            private final String edsServiceName;
            private Map<Locality, String> localityPriorityNames;
            int priorityNameGenId;

            private EdsClusterState(@Nullable String name, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, EnvoyServerProtoData.OutlierDetection outlierDetection) {
                super(name, lrsServerInfo, maxConcurrentRequests, tlsContext, outlierDetection);
                this.localityPriorityNames = Collections.emptyMap();
                this.priorityNameGenId = 1;
                this.edsServiceName = edsServiceName;
            }

            @Override
            void start() {
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.watchXdsResource(XdsEndpointResource.getInstance(), resourceName, this);
            }

            @Override
            protected void shutdown() {
                super.shutdown();
                String resourceName = this.edsServiceName != null ? this.edsServiceName : this.name;
                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stop watching EDS resource {0}", resourceName);
                ClusterResolverLoadBalancer.this.xdsClient.cancelXdsResourceWatch(XdsEndpointResource.getInstance(), resourceName, this);
            }

            @Override
            public void onChanged(final XdsEndpointResource.EdsUpdate update) {
                class EndpointsUpdated
                implements Runnable {
                    EndpointsUpdated() {
                    }

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received endpoint update {0}", update);
                        if (ClusterResolverLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0}: {1} localities, {2} drop categories", update.clusterName, update.localityLbEndpointsMap.size(), update.dropPolicies.size());
                        }
                        Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints = update.localityLbEndpointsMap;
                        List<Endpoints.DropOverload> dropOverloads = update.dropPolicies;
                        ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
                        HashMap prioritizedLocalityWeights = new HashMap();
                        List sortedPriorityNames = EdsClusterState.this.generatePriorityNames(EdsClusterState.this.name, localityLbEndpoints);
                        for (Locality locality : localityLbEndpoints.keySet()) {
                            Endpoints.LocalityLbEndpoints localityLbInfo = localityLbEndpoints.get(locality);
                            String priorityName = (String)EdsClusterState.this.localityPriorityNames.get(locality);
                            boolean discard = true;
                            for (Endpoints.LbEndpoint endpoint : localityLbInfo.endpoints()) {
                                if (!endpoint.isHealthy()) continue;
                                discard = false;
                                long weight = localityLbInfo.localityWeight();
                                if (endpoint.loadBalancingWeight() != 0) {
                                    weight *= (long)endpoint.loadBalancingWeight();
                                }
                                Attributes attr = endpoint.eag().getAttributes().toBuilder().set(InternalXdsAttributes.ATTR_LOCALITY, locality).set(InternalXdsAttributes.ATTR_LOCALITY_WEIGHT, localityLbInfo.localityWeight()).set(InternalXdsAttributes.ATTR_SERVER_WEIGHT, weight).build();
                                EquivalentAddressGroup eag = new EquivalentAddressGroup(endpoint.eag().getAddresses(), attr);
                                eag = AddressFilter.setPathFilter(eag, Arrays.asList(priorityName, ClusterResolverLoadBalancer.localityName(locality)));
                                addresses.add(eag);
                            }
                            if (discard) {
                                ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Discard locality {0} with 0 healthy endpoints", locality);
                                continue;
                            }
                            if (!prioritizedLocalityWeights.containsKey(priorityName)) {
                                prioritizedLocalityWeights.put(priorityName, new HashMap());
                            }
                            ((Map)prioritizedLocalityWeights.get(priorityName)).put(locality, localityLbInfo.localityWeight());
                        }
                        if (prioritizedLocalityWeights.isEmpty()) {
                            ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cluster {0} has no usable priority/locality/endpoint", update.clusterName);
                        }
                        sortedPriorityNames.retainAll(prioritizedLocalityWeights.keySet());
                        Map priorityChildConfigs = ClusterResolverLoadBalancer.generateEdsBasedPriorityChildConfigs(EdsClusterState.this.name, EdsClusterState.this.edsServiceName, EdsClusterState.this.lrsServerInfo, EdsClusterState.this.maxConcurrentRequests, EdsClusterState.this.tlsContext, EdsClusterState.this.outlierDetection, ClusterResolverLbState.this.endpointLbPolicy, ClusterResolverLoadBalancer.this.lbRegistry, prioritizedLocalityWeights, dropOverloads);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = new ClusterResolutionResult(addresses, priorityChildConfigs, sortedPriorityNames);
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                }
                ClusterResolverLoadBalancer.this.syncContext.execute(new EndpointsUpdated());
            }

            private List<String> generatePriorityNames(String name, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints) {
                TreeMap todo = new TreeMap();
                for (Locality locality : localityLbEndpoints.keySet()) {
                    int priority = localityLbEndpoints.get(locality).priority();
                    if (!todo.containsKey(priority)) {
                        todo.put(priority, new ArrayList());
                    }
                    ((List)todo.get(priority)).add(locality);
                }
                HashMap<Locality, String> newNames = new HashMap<Locality, String>();
                HashSet<String> usedNames = new HashSet<String>();
                ArrayList<String> ret = new ArrayList<String>();
                for (Integer priority : todo.keySet()) {
                    String foundName = "";
                    for (Locality locality : (List)todo.get(priority)) {
                        if (!this.localityPriorityNames.containsKey(locality) || !usedNames.add(this.localityPriorityNames.get(locality))) continue;
                        foundName = this.localityPriorityNames.get(locality);
                        break;
                    }
                    if ("".equals(foundName)) {
                        foundName = String.format(Locale.US, "%s[child%d]", name, this.priorityNameGenId++);
                    }
                    for (Locality locality : (List)todo.get(priority)) {
                        newNames.put(locality, foundName);
                    }
                    ret.add(foundName);
                }
                this.localityPriorityNames = newNames;
                return ret;
            }

            @Override
            public void onResourceDoesNotExist(final String resourceName) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Resource {0} unavailable", resourceName);
                        EdsClusterState.this.status = Status.OK;
                        EdsClusterState.this.resolved = true;
                        EdsClusterState.this.result = null;
                        ClusterResolverLbState.this.handleEndpointResourceUpdate();
                    }
                });
            }

            @Override
            public void onError(final Status error) {
                ClusterResolverLoadBalancer.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (EdsClusterState.this.shutdown) {
                            return;
                        }
                        String resourceName = EdsClusterState.this.edsServiceName != null ? EdsClusterState.this.edsServiceName : EdsClusterState.this.name;
                        EdsClusterState.this.status = Status.UNAVAILABLE.withDescription(String.format("Unable to load EDS %s. xDS server returned: %s: %s", new Object[]{resourceName, error.getCode(), error.getDescription()})).withCause(error.getCause());
                        ClusterResolverLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received EDS error: {0}", error);
                        ClusterResolverLbState.this.handleEndpointResolutionError();
                    }
                });
            }
        }

        private abstract class ClusterState {
            protected final String name;
            @Nullable
            protected final Bootstrapper.ServerInfo lrsServerInfo;
            @Nullable
            protected final Long maxConcurrentRequests;
            @Nullable
            protected final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
            @Nullable
            protected final EnvoyServerProtoData.OutlierDetection outlierDetection;
            protected Status status = Status.OK;
            protected boolean resolved;
            @Nullable
            protected ClusterResolutionResult result;
            protected boolean shutdown;

            private ClusterState(@Nullable String name, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, EnvoyServerProtoData.OutlierDetection outlierDetection) {
                this.name = name;
                this.lrsServerInfo = lrsServerInfo;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.tlsContext = tlsContext;
                this.outlierDetection = outlierDetection;
            }

            abstract void start();

            void shutdown() {
                this.shutdown = true;
            }
        }

        private final class RefreshableHelper
        extends ForwardingLoadBalancerHelper {
            private final LoadBalancer.Helper delegate;

            private RefreshableHelper(LoadBalancer.Helper delegate) {
                this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            }

            @Override
            public void refreshNameResolution() {
                for (ClusterState state : ClusterResolverLbState.this.clusterStates.values()) {
                    if (!(state instanceof LogicalDnsClusterState)) continue;
                    ((LogicalDnsClusterState)state).refresh();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }
        }
    }

    private final class ClusterResolverLbStateFactory
    extends LoadBalancer.Factory {
        private ClusterResolverLbStateFactory() {
        }

        @Override
        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new ClusterResolverLbState(helper);
        }
    }
}

