/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.protoloader;

import com.google.api.Service;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Transport;
import com.google.api.generator.gapic.protoparser.Parser;
import com.google.api.generator.gapic.protoparser.ServiceConfigParser;
import com.google.api.generator.gapic.protoparser.ServiceYamlParser;
import com.google.api.generator.test.protoloader.TestProtoLoader;
import com.google.common.truth.Truth;
import com.google.longrunning.OperationsProto;
import com.google.protobuf.Descriptors;
import com.google.protobuf.StructProto;
import com.google.showcase.v1beta1.ComplianceOuterClass;
import com.google.showcase.v1beta1.EchoOuterClass;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RestTestProtoLoader
extends TestProtoLoader {
    private static final RestTestProtoLoader INSTANCE = new RestTestProtoLoader();

    protected RestTestProtoLoader() {
        super(Transport.REST, "src/test/resources/");
    }

    public static RestTestProtoLoader instance() {
        return INSTANCE;
    }

    public GapicContext parseCompliance() {
        Descriptors.FileDescriptor complianceFileDescriptor = ComplianceOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor complianceServiceDescriptor = (Descriptors.ServiceDescriptor)complianceFileDescriptor.getServices().get(0);
        Truth.assertThat((String)complianceServiceDescriptor.getName()).isEqualTo((Object)"Compliance");
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)complianceFileDescriptor);
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)complianceFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)complianceFileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Truth.assertThat((Boolean)configOpt.isPresent()).isTrue();
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.getTransport()).setRestNumericEnumsEnabled(true).build();
    }

    public GapicContext parseEcho() {
        Descriptors.FileDescriptor echoFileDescriptor = EchoOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor echoServiceDescriptor = (Descriptors.ServiceDescriptor)echoFileDescriptor.getServices().get(0);
        Truth.assertThat((String)echoServiceDescriptor.getName()).isEqualTo((Object)"Echo");
        String serviceYamlFileName = "echo_v1beta1.yaml";
        Path serviceYamlPath = Paths.get(this.getTestFilesDirectory(), serviceYamlFileName);
        Optional serviceYamlOpt = ServiceYamlParser.parse((String)serviceYamlPath.toString());
        Truth.assertThat((Boolean)serviceYamlOpt.isPresent()).isTrue();
        Service service = (Service)serviceYamlOpt.get();
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)echoFileDescriptor);
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)OperationsProto.getDescriptor()));
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)StructProto.getDescriptor()));
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)echoFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)echoFileDescriptor, (Map)messageTypes, (Map)resourceNames, (Optional)serviceYamlOpt, outputResourceNames);
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Truth.assertThat((Boolean)configOpt.isPresent()).isTrue();
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setServiceYamlProto(service).setHelperResourceNames(outputResourceNames).setTransport(this.getTransport()).setRestNumericEnumsEnabled(true).build();
    }
}

