/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Service;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_Service
extends Service {
    private final String name;
    @Nullable
    private final String apiVersion;
    private final String defaultHost;
    private final ImmutableList<String> oauthScopes;
    private final String pakkage;
    private final String protoPakkage;
    private final String originalJavaPackage;
    private final String overriddenName;
    private final boolean isDeprecated;
    private final ImmutableList<Method> methods;
    @Nullable
    private final String description;

    private AutoValue_Service(String name, @Nullable String apiVersion, String defaultHost, ImmutableList<String> oauthScopes, String pakkage, String protoPakkage, String originalJavaPackage, String overriddenName, boolean isDeprecated, ImmutableList<Method> methods, @Nullable String description) {
        this.name = name;
        this.apiVersion = apiVersion;
        this.defaultHost = defaultHost;
        this.oauthScopes = oauthScopes;
        this.pakkage = pakkage;
        this.protoPakkage = protoPakkage;
        this.originalJavaPackage = originalJavaPackage;
        this.overriddenName = overriddenName;
        this.isDeprecated = isDeprecated;
        this.methods = methods;
        this.description = description;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    public String defaultHost() {
        return this.defaultHost;
    }

    @Override
    public ImmutableList<String> oauthScopes() {
        return this.oauthScopes;
    }

    @Override
    public String pakkage() {
        return this.pakkage;
    }

    @Override
    public String protoPakkage() {
        return this.protoPakkage;
    }

    @Override
    public String originalJavaPackage() {
        return this.originalJavaPackage;
    }

    @Override
    public String overriddenName() {
        return this.overriddenName;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public ImmutableList<Method> methods() {
        return this.methods;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    public String toString() {
        return "Service{name=" + this.name + ", apiVersion=" + this.apiVersion + ", defaultHost=" + this.defaultHost + ", oauthScopes=" + this.oauthScopes + ", pakkage=" + this.pakkage + ", protoPakkage=" + this.protoPakkage + ", originalJavaPackage=" + this.originalJavaPackage + ", overriddenName=" + this.overriddenName + ", isDeprecated=" + this.isDeprecated + ", methods=" + this.methods + ", description=" + this.description + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Service) {
            Service that = (Service)o;
            return this.name.equals(that.name()) && (this.apiVersion == null ? that.apiVersion() == null : this.apiVersion.equals(that.apiVersion())) && this.defaultHost.equals(that.defaultHost()) && this.oauthScopes.equals(that.oauthScopes()) && this.pakkage.equals(that.pakkage()) && this.protoPakkage.equals(that.protoPakkage()) && this.originalJavaPackage.equals(that.originalJavaPackage()) && this.overriddenName.equals(that.overriddenName()) && this.isDeprecated == that.isDeprecated() && this.methods.equals(that.methods()) && (this.description == null ? that.description() == null : this.description.equals(that.description()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiVersion == null ? 0 : this.apiVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.defaultHost.hashCode();
        h$ *= 1000003;
        h$ ^= this.oauthScopes.hashCode();
        h$ *= 1000003;
        h$ ^= this.pakkage.hashCode();
        h$ *= 1000003;
        h$ ^= this.protoPakkage.hashCode();
        h$ *= 1000003;
        h$ ^= this.originalJavaPackage.hashCode();
        h$ *= 1000003;
        h$ ^= this.overriddenName.hashCode();
        h$ *= 1000003;
        h$ ^= this.isDeprecated ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.methods.hashCode();
        h$ *= 1000003;
        return h$ ^= this.description == null ? 0 : this.description.hashCode();
    }

    @Override
    public Service.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Service.Builder {
        private String name;
        private String apiVersion;
        private String defaultHost;
        private ImmutableList<String> oauthScopes;
        private String pakkage;
        private String protoPakkage;
        private String originalJavaPackage;
        private String overriddenName;
        private boolean isDeprecated;
        private ImmutableList<Method> methods;
        private String description;
        private byte set$0;

        Builder() {
        }

        private Builder(Service source) {
            this.name = source.name();
            this.apiVersion = source.apiVersion();
            this.defaultHost = source.defaultHost();
            this.oauthScopes = source.oauthScopes();
            this.pakkage = source.pakkage();
            this.protoPakkage = source.protoPakkage();
            this.originalJavaPackage = source.originalJavaPackage();
            this.overriddenName = source.overriddenName();
            this.isDeprecated = source.isDeprecated();
            this.methods = source.methods();
            this.description = source.description();
            this.set$0 = 1;
        }

        @Override
        public Service.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Service.Builder setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @Override
        public Service.Builder setDefaultHost(String defaultHost) {
            if (defaultHost == null) {
                throw new NullPointerException("Null defaultHost");
            }
            this.defaultHost = defaultHost;
            return this;
        }

        @Override
        public Service.Builder setOauthScopes(List<String> oauthScopes) {
            this.oauthScopes = ImmutableList.copyOf(oauthScopes);
            return this;
        }

        @Override
        public Service.Builder setPakkage(String pakkage) {
            if (pakkage == null) {
                throw new NullPointerException("Null pakkage");
            }
            this.pakkage = pakkage;
            return this;
        }

        @Override
        public Service.Builder setProtoPakkage(String protoPakkage) {
            if (protoPakkage == null) {
                throw new NullPointerException("Null protoPakkage");
            }
            this.protoPakkage = protoPakkage;
            return this;
        }

        @Override
        public Service.Builder setOriginalJavaPackage(String originalJavaPackage) {
            if (originalJavaPackage == null) {
                throw new NullPointerException("Null originalJavaPackage");
            }
            this.originalJavaPackage = originalJavaPackage;
            return this;
        }

        @Override
        public Service.Builder setOverriddenName(String overriddenName) {
            if (overriddenName == null) {
                throw new NullPointerException("Null overriddenName");
            }
            this.overriddenName = overriddenName;
            return this;
        }

        @Override
        public Service.Builder setIsDeprecated(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public Service.Builder setMethods(List<Method> methods) {
            this.methods = ImmutableList.copyOf(methods);
            return this;
        }

        @Override
        public Service.Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Service build() {
            if (this.set$0 != 1 || this.name == null || this.defaultHost == null || this.oauthScopes == null || this.pakkage == null || this.protoPakkage == null || this.originalJavaPackage == null || this.overriddenName == null || this.methods == null) {
                StringBuilder missing = new StringBuilder();
                if (this.name == null) {
                    missing.append(" name");
                }
                if (this.defaultHost == null) {
                    missing.append(" defaultHost");
                }
                if (this.oauthScopes == null) {
                    missing.append(" oauthScopes");
                }
                if (this.pakkage == null) {
                    missing.append(" pakkage");
                }
                if (this.protoPakkage == null) {
                    missing.append(" protoPakkage");
                }
                if (this.originalJavaPackage == null) {
                    missing.append(" originalJavaPackage");
                }
                if (this.overriddenName == null) {
                    missing.append(" overriddenName");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" isDeprecated");
                }
                if (this.methods == null) {
                    missing.append(" methods");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Service(this.name, this.apiVersion, this.defaultHost, this.oauthScopes, this.pakkage, this.protoPakkage, this.originalJavaPackage, this.overriddenName, this.isDeprecated, this.methods, this.description);
        }
    }
}

