/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.LeastRequestLoadBalancerProvider;
import io.grpc.xds.ThreadSafeRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

final class LeastRequestLoadBalancer
extends MultiChildLoadBalancer {
    private static final Status EMPTY_OK = Status.OK.withDescription("no subchannels ready");
    private static final EmptyPicker EMPTY_LR_PICKER = new EmptyPicker(EMPTY_OK);
    private final ThreadSafeRandom random;
    private LeastRequestPicker currentPicker = EMPTY_LR_PICKER;
    private int choiceCount = LeastRequestLoadBalancerProvider.DEFAULT_CHOICE_COUNT;

    LeastRequestLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
    }

    @VisibleForTesting
    LeastRequestLoadBalancer(LoadBalancer.Helper helper, ThreadSafeRandom random) {
        super(helper);
        this.random = Preconditions.checkNotNull(random, "random");
    }

    @Override
    protected LoadBalancer.SubchannelPicker getSubchannelPicker(Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        throw new UnsupportedOperationException("LeastRequestLoadBalancer uses its ChildLbStates, not these child pickers directly");
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Status addressAcceptanceStatus;
        int oldChoiceCount = this.choiceCount;
        LeastRequestConfig config = (LeastRequestConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        if (config != null) {
            this.choiceCount = config.choiceCount;
        }
        if (!(addressAcceptanceStatus = super.acceptResolvedAddresses(resolvedAddresses)).isOk()) {
            this.choiceCount = oldChoiceCount;
        }
        return addressAcceptanceStatus;
    }

    @Override
    protected LoadBalancer.SubchannelPicker getErrorPicker(Status error) {
        return new EmptyPicker(error);
    }

    @Override
    protected void updateOverallBalancingState() {
        List<MultiChildLoadBalancer.ChildLbState> activeList = this.getReadyChildren();
        if (activeList.isEmpty()) {
            boolean isConnecting = false;
            ArrayList<MultiChildLoadBalancer.ChildLbState> childrenInTf = new ArrayList<MultiChildLoadBalancer.ChildLbState>();
            for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
                ConnectivityState state = childLbState.getCurrentState();
                if (state == ConnectivityState.CONNECTING || state == ConnectivityState.IDLE) {
                    isConnecting = true;
                    continue;
                }
                if (state != ConnectivityState.TRANSIENT_FAILURE) continue;
                childrenInTf.add(childLbState);
            }
            if (isConnecting) {
                this.updateBalancingState(ConnectivityState.CONNECTING, EMPTY_LR_PICKER);
            } else {
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ReadyPicker(childrenInTf, this.choiceCount, this.random));
            }
        } else {
            this.updateBalancingState(ConnectivityState.READY, new ReadyPicker(activeList, this.choiceCount, this.random));
        }
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key, Object policyConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses unused) {
        return new LeastRequestLbState(key, this.pickFirstLbProvider, policyConfig, initialPicker);
    }

    private void updateBalancingState(ConnectivityState state, LeastRequestPicker picker) {
        if (state != this.currentConnectivityState || !picker.isEquivalentTo(this.currentPicker)) {
            this.getHelper().updateBalancingState(state, picker);
            this.currentConnectivityState = state;
            this.currentPicker = picker;
        }
    }

    @VisibleForTesting
    void setResolvingAddresses(boolean newValue) {
        this.resolvingAddresses = newValue;
    }

    @Override
    protected Collection<MultiChildLoadBalancer.ChildLbState> getChildLbStates() {
        return super.getChildLbStates();
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState getChildLbState(Object key) {
        return super.getChildLbState(key);
    }

    private static AtomicInteger getInFlights(MultiChildLoadBalancer.ChildLbState childLbState) {
        return ((LeastRequestLbState)childLbState).activeRequests;
    }

    protected class LeastRequestLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final AtomicInteger activeRequests;

        public LeastRequestLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            super(key, policyProvider, childConfig, initialPicker);
            this.activeRequests = new AtomicInteger(0);
        }

        int getActiveRequests() {
            return this.activeRequests.get();
        }
    }

    static final class LeastRequestConfig {
        final int choiceCount;

        LeastRequestConfig(int choiceCount) {
            Preconditions.checkArgument(choiceCount >= 2, "choiceCount <= 1");
            this.choiceCount = Math.min(choiceCount, 10);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("choiceCount", this.choiceCount).toString();
        }
    }

    private static final class OutstandingRequestsTracingFactory
    extends ClientStreamTracer.Factory {
        private final AtomicInteger inFlights;

        private OutstandingRequestsTracingFactory(AtomicInteger inFlights) {
            this.inFlights = Preconditions.checkNotNull(inFlights, "inFlights");
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            return new ClientStreamTracer(){

                @Override
                public void streamCreated(Attributes transportAttrs, Metadata headers) {
                    inFlights.incrementAndGet();
                }

                @Override
                public void streamClosed(Status status) {
                    inFlights.decrementAndGet();
                }
            };
        }
    }

    @VisibleForTesting
    static final class EmptyPicker
    extends LeastRequestPicker {
        private final Status status;

        EmptyPicker(@Nonnull Status status) {
            this.status = Preconditions.checkNotNull(status, "status");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.status.isOk() ? LoadBalancer.PickResult.withNoResult() : LoadBalancer.PickResult.withError(this.status);
        }

        @Override
        boolean isEquivalentTo(LeastRequestPicker picker) {
            return picker instanceof EmptyPicker && (Objects.equal(this.status, ((EmptyPicker)picker).status) || this.status.isOk() && ((EmptyPicker)picker).status.isOk());
        }

        public String toString() {
            return MoreObjects.toStringHelper(EmptyPicker.class).add("status", this.status).toString();
        }

        @VisibleForTesting
        Status getStatus() {
            return this.status;
        }
    }

    @VisibleForTesting
    static final class ReadyPicker
    extends LeastRequestPicker {
        private final List<MultiChildLoadBalancer.ChildLbState> childLbStates;
        private final int choiceCount;
        private final ThreadSafeRandom random;

        ReadyPicker(List<MultiChildLoadBalancer.ChildLbState> childLbStates, int choiceCount, ThreadSafeRandom random) {
            Preconditions.checkArgument(!childLbStates.isEmpty(), "empty list");
            this.childLbStates = childLbStates;
            this.choiceCount = choiceCount;
            this.random = Preconditions.checkNotNull(random, "random");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            MultiChildLoadBalancer.ChildLbState childLbState = this.nextChildToUse();
            LoadBalancer.PickResult childResult = childLbState.getCurrentPicker().pickSubchannel(args);
            if (!childResult.getStatus().isOk() || childResult.getSubchannel() == null) {
                return childResult;
            }
            if (childResult.getStreamTracerFactory() != null) {
                return childResult;
            }
            OutstandingRequestsTracingFactory factory = new OutstandingRequestsTracingFactory(LeastRequestLoadBalancer.getInFlights(childLbState));
            return LoadBalancer.PickResult.withSubchannel(childResult.getSubchannel(), factory);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ReadyPicker.class).add("list", this.childLbStates).add("choiceCount", this.choiceCount).toString();
        }

        private MultiChildLoadBalancer.ChildLbState nextChildToUse() {
            MultiChildLoadBalancer.ChildLbState candidate = this.childLbStates.get(this.random.nextInt(this.childLbStates.size()));
            for (int i = 0; i < this.choiceCount - 1; ++i) {
                MultiChildLoadBalancer.ChildLbState sampled = this.childLbStates.get(this.random.nextInt(this.childLbStates.size()));
                if (LeastRequestLoadBalancer.getInFlights(sampled).get() >= LeastRequestLoadBalancer.getInFlights(candidate).get()) continue;
                candidate = sampled;
            }
            return candidate;
        }

        @VisibleForTesting
        List<MultiChildLoadBalancer.ChildLbState> getChildLbStates() {
            return this.childLbStates;
        }

        @Override
        @VisibleForTesting
        boolean isEquivalentTo(LeastRequestPicker picker) {
            if (!(picker instanceof ReadyPicker)) {
                return false;
            }
            ReadyPicker other = (ReadyPicker)picker;
            return other == this || this.childLbStates.size() == other.childLbStates.size() && new HashSet<MultiChildLoadBalancer.ChildLbState>(this.childLbStates).containsAll(other.childLbStates) && this.choiceCount == other.choiceCount;
        }
    }

    @VisibleForTesting
    static abstract class LeastRequestPicker
    extends LoadBalancer.SubchannelPicker {
        LeastRequestPicker() {
        }

        abstract boolean isEquivalentTo(LeastRequestPicker var1);
    }
}

