/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.util;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

public class TimeConversionTestUtils {
    public static <Target> void testInstantMethod(Long testValue, Function<java.time.Instant, Target> javaTimeTargetSupplier, Function<Instant, Target> threetenTargetSupplier, Function<Target, java.time.Instant> javaTimeGetter, Function<Target, Instant> threetenGetter) {
        Function<java.time.Instant, Long> javaTimeTester = value -> value.toEpochMilli();
        Function<Instant, Long> threetenTester = value -> value.toEpochMilli();
        java.time.Instant javaTimeSupplierValue = testValue == null ? null : java.time.Instant.ofEpochMilli(testValue);
        Instant threetenSupplierValue = testValue == null ? null : Instant.ofEpochMilli(testValue);
        TimeConversionTestUtils.testTimeObjectMethod(testValue, javaTimeSupplierValue, javaTimeTargetSupplier, javaTimeGetter, threetenGetter, javaTimeTester, threetenTester);
        TimeConversionTestUtils.testTimeObjectMethod(testValue, threetenSupplierValue, threetenTargetSupplier, javaTimeGetter, threetenGetter, javaTimeTester, threetenTester);
    }

    public static <Target> void testDurationMethod(Long testValue, Function<java.time.Duration, Target> javaTimeTargetSupplier, Function<Duration, Target> threetenTargetSupplier, Function<Target, java.time.Duration> javaTimeGetter, Function<Target, Duration> threetenGetter) {
        Function<java.time.Duration, Long> javaTimeTester = value -> value.toMillis();
        Function<Duration, Long> threetenTester = value -> value.toMillis();
        java.time.Duration javaTimeSupplierValue = testValue == null ? null : java.time.Duration.ofMillis(testValue);
        Duration threetenSupplierValue = testValue == null ? null : Duration.ofMillis(testValue);
        TimeConversionTestUtils.testTimeObjectMethod(testValue, javaTimeSupplierValue, javaTimeTargetSupplier, javaTimeGetter, threetenGetter, javaTimeTester, threetenTester);
        TimeConversionTestUtils.testTimeObjectMethod(testValue, threetenSupplierValue, threetenTargetSupplier, javaTimeGetter, threetenGetter, javaTimeTester, threetenTester);
    }

    private static <Target, Threeten, JavaTime, SupplierType> void testTimeObjectMethod(Long testValue, SupplierType targetSupplierValue, Function<SupplierType, Target> targetSupplier, Function<Target, JavaTime> javaTimeGetter, Function<Target, Threeten> threetenGetter, Function<JavaTime, Long> javaTimeTester, Function<Threeten, Long> threetenTester) {
        Target target = targetSupplier.apply(targetSupplierValue);
        JavaTime javaTimeValue = javaTimeGetter.apply(target);
        Threeten threetenValue = threetenGetter.apply(target);
        if (testValue == null) {
            Assertions.assertNull(javaTimeValue);
            Assertions.assertNull(threetenValue);
        } else {
            Assertions.assertEquals((long)testValue, (long)javaTimeTester.apply(javaTimeValue));
            Assertions.assertEquals((long)testValue, (long)threetenTester.apply(threetenValue));
        }
    }
}

