/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ClassDefinition;
import com.google.api.generator.engine.ast.BlockStatement;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.model.RegionTag;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

@AutoValue
public abstract class ClassDefinition
implements AstNode {
    public abstract ImmutableList<CommentStatement> fileHeader();

    @Nullable
    public abstract RegionTag regionTag();

    public abstract ScopeNode scope();

    public abstract IdentifierNode classIdentifier();

    @Nullable
    public abstract String packageString();

    public abstract boolean isNested();

    public abstract ImmutableList<CommentStatement> headerCommentStatements();

    public abstract ImmutableList<AnnotationNode> annotations();

    public abstract ImmutableList<TypeNode> implementsTypes();

    @Nullable
    public abstract TypeNode extendsType();

    public abstract boolean isStatic();

    public abstract boolean isFinal();

    public abstract boolean isAbstract();

    public abstract ImmutableList<Statement> statements();

    public abstract ImmutableList<MethodDefinition> methods();

    public abstract ImmutableList<ClassDefinition> nestedClasses();

    abstract String name();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_ClassDefinition.Builder().setFileHeader(Collections.emptyList()).setHeaderCommentStatements(Collections.emptyList()).setIsNested(false).setIsFinal(false).setIsStatic(false).setIsAbstract(false).setAnnotations(Collections.emptyList()).setImplementsTypes(Collections.emptyList()).setStatements(Collections.emptyList()).setMethods(Collections.emptyList()).setNestedClasses(Collections.emptyList());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public Builder setFileHeader(CommentStatement ... headerComments) {
            return this.setFileHeader(Arrays.asList(headerComments));
        }

        public abstract Builder setFileHeader(List<CommentStatement> var1);

        public abstract Builder setRegionTag(RegionTag var1);

        public Builder setHeaderCommentStatements(CommentStatement ... comments) {
            return this.setHeaderCommentStatements(Arrays.asList(comments));
        }

        public abstract Builder setHeaderCommentStatements(List<CommentStatement> var1);

        public abstract Builder setScope(ScopeNode var1);

        public abstract Builder setPackageString(String var1);

        public abstract Builder setName(String var1);

        public abstract Builder setIsNested(boolean var1);

        public abstract Builder setAnnotations(List<AnnotationNode> var1);

        public abstract Builder setIsAbstract(boolean var1);

        public abstract Builder setIsStatic(boolean var1);

        public abstract Builder setIsFinal(boolean var1);

        public abstract Builder setExtendsType(TypeNode var1);

        public abstract Builder setImplementsTypes(List<TypeNode> var1);

        public abstract Builder setStatements(List<Statement> var1);

        public abstract Builder setMethods(List<MethodDefinition> var1);

        public abstract Builder setNestedClasses(List<ClassDefinition> var1);

        abstract String name();

        abstract ClassDefinition autoBuild();

        abstract Builder setClassIdentifier(IdentifierNode var1);

        public ClassDefinition build() {
            IdentifierNode classIdentifier = IdentifierNode.builder().setName(this.name()).build();
            this.setClassIdentifier(classIdentifier);
            ClassDefinition classDef = this.autoBuild();
            this.performNullChecks(classDef);
            if (!classDef.isNested()) {
                Preconditions.checkNotNull(classDef.packageString(), "Outer classes must have a package name defined");
                Preconditions.checkState(!classDef.isStatic(), "Outer classes cannot be static");
                Preconditions.checkState(!classDef.scope().equals(ScopeNode.PRIVATE), "Outer classes cannot be private");
            } else {
                Preconditions.checkState(classDef.fileHeader().isEmpty(), "Nested classes cannot have a file header");
            }
            if (classDef.isAbstract()) {
                Preconditions.checkState(!classDef.isFinal(), "Abstract classes cannot be marked final");
            }
            if (classDef.extendsType() != null) {
                Preconditions.checkState(TypeNode.isReferenceType(classDef.extendsType()), "Classes cannot extend non-reference types");
                Preconditions.checkState(!classDef.implementsTypes().contains(classDef.extendsType()), "Classes cannot extend and implement the same type");
            }
            for (TypeNode implType : classDef.implementsTypes()) {
                Preconditions.checkState(TypeNode.isReferenceType(implType), "Classes cannot implement non-reference types");
            }
            for (Statement statement : classDef.statements()) {
                VariableExpr variableExpr;
                Preconditions.checkState(statement instanceof CommentStatement || statement instanceof EmptyLineStatement || statement instanceof ExprStatement || statement instanceof BlockStatement, "Class statement type must be either an expression, block, or comment statement");
                if (!(statement instanceof ExprStatement)) continue;
                Expr expr = ((ExprStatement)statement).expression();
                if (expr instanceof VariableExpr) {
                    variableExpr = (VariableExpr)expr;
                    Preconditions.checkState(variableExpr.isDecl(), "Class expression variable statements must be declarations");
                    Preconditions.checkState(!variableExpr.scope().equals(ScopeNode.LOCAL), "Class variable statement cannot have a local scope");
                    continue;
                }
                Preconditions.checkState(expr instanceof AssignmentExpr, "Class expression statement must be assignment or variable declaration");
                variableExpr = ((AssignmentExpr)expr).variableExpr();
                Preconditions.checkState(!variableExpr.scope().equals(ScopeNode.LOCAL), "Class variable in assignment statement cannot have a local scope");
            }
            return classDef;
        }

        void performNullChecks(ClassDefinition classDef) {
            String contextInfo = String.format("class  definition of %s", this.name());
            NodeValidator.checkNoNullElements(classDef.headerCommentStatements(), "header comments", contextInfo);
            NodeValidator.checkNoNullElements(classDef.annotations(), "annotations", contextInfo);
            NodeValidator.checkNoNullElements(classDef.implementsTypes(), "implemented types", contextInfo);
            NodeValidator.checkNoNullElements(classDef.statements(), "statements", contextInfo);
            NodeValidator.checkNoNullElements(classDef.methods(), "methods", contextInfo);
            NodeValidator.checkNoNullElements(classDef.nestedClasses(), "nested classes", contextInfo);
        }
    }
}

