/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_RelationalOperationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class RelationalOperationExpr
implements OperationExpr {
    public abstract Expr lhsExpr();

    public abstract Expr rhsExpr();

    @Override
    public abstract OperatorKind operatorKind();

    @Override
    public TypeNode type() {
        return TypeNode.BOOLEAN;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static RelationalOperationExpr equalToWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return RelationalOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.RELATIONAL_EQUAL_TO).build();
    }

    public static RelationalOperationExpr notEqualToWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return RelationalOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.RELATIONAL_NOT_EQUAL_TO).build();
    }

    public static RelationalOperationExpr lessThanWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return RelationalOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.RELATIONAL_LESS_THAN).build();
    }

    private static Builder builder() {
        return new AutoValue_RelationalOperationExpr.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLhsExpr(Expr var1);

        abstract Builder setRhsExpr(Expr var1);

        abstract Builder setOperatorKind(OperatorKind var1);

        abstract RelationalOperationExpr autoBuild();

        private RelationalOperationExpr build() {
            RelationalOperationExpr relationalOperationExpr = this.autoBuild();
            TypeNode lhsExprType = relationalOperationExpr.lhsExpr().type();
            TypeNode rhsExprType = relationalOperationExpr.rhsExpr().type();
            OperatorKind operator = relationalOperationExpr.operatorKind();
            String errorMsg = String.format("Relational operator %s can not be applied to %s, %s.", new Object[]{operator, lhsExprType.toString(), rhsExprType.toString()});
            if (operator.equals((Object)OperatorKind.RELATIONAL_EQUAL_TO) || operator.equals((Object)OperatorKind.RELATIONAL_NOT_EQUAL_TO)) {
                Preconditions.checkState(this.isValidEqualityType(lhsExprType, rhsExprType), errorMsg);
            }
            if (operator.equals((Object)OperatorKind.RELATIONAL_LESS_THAN)) {
                Preconditions.checkState(this.isValidRelationalType(lhsExprType, rhsExprType), errorMsg);
            }
            return relationalOperationExpr;
        }

        private boolean isValidEqualityType(TypeNode lhsType, TypeNode rhsType) {
            if (lhsType.equals(rhsType)) {
                return true;
            }
            if (lhsType.isArray() || rhsType.isArray()) {
                return lhsType.equals(TypeNode.NULL) || rhsType.equals(TypeNode.NULL);
            }
            if (TypeNode.isNumericType(lhsType) && TypeNode.isNumericType(rhsType)) {
                return true;
            }
            if (lhsType.equals(TypeNode.OBJECT) || lhsType.equals(TypeNode.NULL)) {
                return TypeNode.isReferenceType(rhsType) || rhsType.equals(TypeNode.OBJECT) || rhsType.equals(TypeNode.NULL);
            }
            if (TypeNode.isBoxedType(lhsType) || TypeNode.isReferenceType(lhsType)) {
                return rhsType.equals(TypeNode.NULL) || rhsType.equals(TypeNode.OBJECT);
            }
            return false;
        }

        private boolean isValidRelationalType(TypeNode lhsType, TypeNode rhsType) {
            return TypeNode.isNumericType(lhsType) && TypeNode.isNumericType(rhsType);
        }
    }
}

