/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.framework;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GoldenFileWriter {
    public static void saveCodegenToFile(Class<?> clazz, String fileName, String codegen) {
        if (System.getProperty("updateUnitGoldens") == null) {
            return;
        }
        String relativeGoldenDir = GoldenFileWriter.getTestoutGoldenDir(clazz);
        GoldenFileWriter.saveCodeToFile(relativeGoldenDir, fileName, codegen);
    }

    public static void saveSampleCodegenToFile(Class<?> clazz, String sampleDir, String fileName, String codegen) {
        String relativeGoldenDir = GoldenFileWriter.getTestoutGoldenDir(clazz) + "/samples/" + sampleDir;
        GoldenFileWriter.saveCodeToFile(relativeGoldenDir, fileName, codegen);
    }

    private static void saveCodeToFile(String relativeGoldenDir, String fileName, String codegen) {
        Path testOutputDir = Paths.get("src", "test", "java", relativeGoldenDir);
        testOutputDir.toFile().mkdirs();
        try (FileWriter myWriter = new FileWriter(testOutputDir.resolve(fileName).toFile());){
            myWriter.write(codegen);
        }
        catch (IOException e) {
            throw new SaveCodegenToFileException(String.format("Error occurred when saving codegen to file %s/%s", relativeGoldenDir, fileName));
        }
    }

    private static String getTestoutGoldenDir(Class<?> clazz) {
        return clazz.getPackage().getName().replace(".", "/") + "/goldens/";
    }

    public static String getGoldenDir(Class<?> clazz) {
        return "src/test/java/" + GoldenFileWriter.getTestoutGoldenDir(clazz);
    }

    public static class SaveCodegenToFileException
    extends RuntimeException {
        public SaveCodegenToFileException(String errorMessage) {
            super(errorMessage);
        }
    }
}

