/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.framework;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.writer.JavaWriterVisitor;
import com.google.api.generator.gapic.composer.comment.CommentComposer;
import com.google.api.generator.gapic.composer.samplecode.SampleCodeWriter;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.test.framework.Differ;
import com.google.api.generator.test.framework.GoldenFileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.AssertionFailedError;

public class Assert {
    public static void assertCodeEquals(Path goldenPath, String codegen) {
        List<String> diffList = Differ.diff(goldenPath, codegen);
        if (!diffList.isEmpty()) {
            throw new AssertionFailedError("Differences found: \n" + String.join((CharSequence)"\n", diffList));
        }
    }

    public static void assertCodeEquals(String expected, String codegen) {
        List<String> diffList = Differ.diff(expected, codegen);
        if (!diffList.isEmpty()) {
            throw new AssertionFailedError("Differences found: \n" + String.join((CharSequence)"\n", diffList));
        }
    }

    public static void assertEmptySamples(List<Sample> samples) {
        if (!samples.isEmpty()) {
            List diffList = samples.stream().map(Sample::name).collect(Collectors.toList());
            throw new AssertionFailedError("Differences found: \n" + String.join((CharSequence)"\n", diffList));
        }
    }

    public static void assertGoldenClass(Class<?> clazz, GapicClass gapicClass, String fileName) {
        JavaWriterVisitor visitor = new JavaWriterVisitor();
        gapicClass.classDefinition().accept((AstNodeVisitor)visitor);
        GoldenFileWriter.saveCodegenToFile(clazz, fileName, visitor.write());
        Path goldenFilePath = Paths.get(GoldenFileWriter.getGoldenDir(clazz), fileName);
        Assert.assertCodeEquals(goldenFilePath, visitor.write());
    }

    public static void assertGoldenSamples(Class<?> clazz, String sampleDirName, String packkage, List<Sample> samples) {
        for (Sample sample : samples) {
            String fileName = sample.name() + ".golden";
            String goldenSampleDir = GoldenFileWriter.getGoldenDir(clazz) + "/samples/" + sampleDirName.toLowerCase() + "/";
            Path goldenFilePath = Paths.get(goldenSampleDir, fileName);
            sample = sample.withHeader(Arrays.asList(CommentComposer.APACHE_LICENSE_COMMENT)).withRegionTag(sample.regionTag().withApiShortName("goldenSample"));
            String sampleString = SampleCodeWriter.writeExecutableSample((Sample)sample, (String)(packkage + ".samples"));
            GoldenFileWriter.saveSampleCodegenToFile(clazz, sampleDirName.toLowerCase(), fileName, sampleString);
            Assert.assertCodeEquals(goldenFilePath, sampleString);
        }
    }
}

