/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.CertificateBasedAccess;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CertificateBasedAccessTest {
    CertificateBasedAccessTest() {
    }

    @Test
    void testUseMtlsEndpointAlways() {
        CertificateBasedAccess cba = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "always" : "false");
        Assertions.assertEquals((Object)((Object)CertificateBasedAccess.MtlsEndpointUsagePolicy.ALWAYS), (Object)((Object)cba.getMtlsEndpointUsagePolicy()));
    }

    @Test
    void testUseMtlsEndpointAuto() {
        CertificateBasedAccess cba = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "auto" : "false");
        Assertions.assertEquals((Object)((Object)CertificateBasedAccess.MtlsEndpointUsagePolicy.AUTO), (Object)((Object)cba.getMtlsEndpointUsagePolicy()));
    }

    @Test
    void testUseMtlsEndpointNever() {
        CertificateBasedAccess cba = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_MTLS_ENDPOINT") ? "never" : "false");
        Assertions.assertEquals((Object)((Object)CertificateBasedAccess.MtlsEndpointUsagePolicy.NEVER), (Object)((Object)cba.getMtlsEndpointUsagePolicy()));
    }

    @Test
    void testUseMtlsClientCertificateTrue() {
        CertificateBasedAccess cba = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_CLIENT_CERTIFICATE") ? "true" : "auto");
        Assertions.assertTrue((boolean)cba.useMtlsClientCertificate());
    }

    @Test
    void testUseMtlsClientCertificateFalse() {
        CertificateBasedAccess cba = new CertificateBasedAccess(name -> name.equals("GOOGLE_API_USE_CLIENT_CERTIFICATE") ? "false" : "auto");
        Assertions.assertFalse((boolean)cba.useMtlsClientCertificate());
    }
}

