/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ApiExceptions;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.OperationCallSettings;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Message;
import io.grpc.Channel;
import java.util.concurrent.ScheduledExecutorService;
import org.threeten.bp.Duration;

@BetaApi
public final class OperationCallable<RequestT, ResponseT extends Message> {
    private final UnaryCallable<RequestT, Operation> initialCallable;
    private final Channel channel;
    private final ScheduledExecutorService executor;
    private final OperationsClient operationsClient;
    private final Class<ResponseT> responseClass;
    private final OperationCallSettings settings;

    OperationCallable(UnaryCallable<RequestT, Operation> initialCallable, Channel channel, ScheduledExecutorService executor, OperationsClient operationsClient, Class<ResponseT> responseClass, OperationCallSettings settings) {
        this.initialCallable = (UnaryCallable)Preconditions.checkNotNull(initialCallable);
        this.channel = channel;
        this.executor = executor;
        this.operationsClient = operationsClient;
        this.responseClass = responseClass;
        this.settings = settings;
    }

    OperationCallable<RequestT, ResponseT> bind(Channel boundChannel) {
        return new OperationCallable<RequestT, ResponseT>(this.initialCallable, boundChannel, this.executor, this.operationsClient, this.responseClass, this.settings);
    }

    public static <RequestT, ResponseT extends Message> OperationCallable<RequestT, ResponseT> create(OperationCallSettings<RequestT, ResponseT> operationCallSettings, Channel channel, ScheduledExecutorService executor, OperationsClient operationsClient) {
        return operationCallSettings.createOperationCallable(channel, executor, operationsClient);
    }

    public OperationFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.channel);
        }
        ApiFuture<Operation> initialCallFuture = this.initialCallable.futureCall(request, context);
        Duration pollingInterval = this.settings != null ? this.settings.getPollingInterval() : OperationFuture.DEFAULT_POLLING_INTERVAL;
        OperationFuture<ResponseT> operationFuture = OperationFuture.create(this.operationsClient, initialCallFuture, this.executor, this.responseClass, pollingInterval);
        return operationFuture;
    }

    public OperationFuture<ResponseT> futureCall(RequestT request) {
        return this.futureCall(request, CallContext.createDefault().withChannel(this.channel));
    }

    public ResponseT call(RequestT request, CallContext context) {
        return (ResponseT)((Message)ApiExceptions.callAndTranslateApiException(this.futureCall(request, context)));
    }

    public ResponseT call(RequestT request) {
        return (ResponseT)((Message)ApiExceptions.callAndTranslateApiException(this.futureCall(request)));
    }

    public OperationFuture<ResponseT> resumeFutureCall(String operationName) {
        ApiFuture<Operation> getOperationFuture = this.operationsClient.getOperationCallable().futureCall(GetOperationRequest.newBuilder().setName(operationName).build());
        OperationFuture<ResponseT> operationFuture = OperationFuture.create(this.operationsClient, getOperationFuture, this.executor, this.responseClass);
        return operationFuture;
    }
}

