/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ClientContext;
import com.google.auth.Credentials;
import io.grpc.Channel;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

final class AutoValue_ClientContext
extends ClientContext {
    private final Collection<AutoCloseable> closeables;
    private final Channel channel;
    private final ScheduledExecutorService executor;
    private final Credentials credentials;

    private AutoValue_ClientContext(Collection<AutoCloseable> closeables, Channel channel, ScheduledExecutorService executor, @Nullable Credentials credentials) {
        if (closeables == null) {
            throw new NullPointerException("Null closeables");
        }
        this.closeables = closeables;
        if (channel == null) {
            throw new NullPointerException("Null channel");
        }
        this.channel = channel;
        if (executor == null) {
            throw new NullPointerException("Null executor");
        }
        this.executor = executor;
        this.credentials = credentials;
    }

    @Override
    public Collection<AutoCloseable> getCloseables() {
        return this.closeables;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return "ClientContext{closeables=" + this.closeables + ", channel=" + this.channel + ", executor=" + this.executor + ", credentials=" + this.credentials + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClientContext) {
            ClientContext that = (ClientContext)o;
            return this.closeables.equals(that.getCloseables()) && this.channel.equals(that.getChannel()) && this.executor.equals(that.getExecutor()) && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.closeables.hashCode();
        h *= 1000003;
        h ^= this.channel.hashCode();
        h *= 1000003;
        h ^= this.executor.hashCode();
        h *= 1000003;
        return h ^= this.credentials == null ? 0 : this.credentials.hashCode();
    }

    static final class Builder
    extends ClientContext.Builder {
        private Collection<AutoCloseable> closeables;
        private Channel channel;
        private ScheduledExecutorService executor;
        private Credentials credentials;

        Builder() {
        }

        Builder(ClientContext source) {
            this.closeables = source.getCloseables();
            this.channel = source.getChannel();
            this.executor = source.getExecutor();
            this.credentials = source.getCredentials();
        }

        @Override
        public ClientContext.Builder setCloseables(Collection<AutoCloseable> closeables) {
            this.closeables = closeables;
            return this;
        }

        @Override
        public ClientContext.Builder setChannel(Channel channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public ClientContext.Builder setExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public ClientContext.Builder setCredentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public ClientContext build() {
            String missing = "";
            if (this.closeables == null) {
                missing = missing + " closeables";
            }
            if (this.channel == null) {
                missing = missing + " channel";
            }
            if (this.executor == null) {
                missing = missing + " executor";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ClientContext(this.closeables, this.channel, this.executor, this.credentials);
        }
    }
}

