/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.ThresholdBatchReceiver;
import com.google.api.gax.grpc.Batch;
import com.google.api.gax.grpc.BatchedRequestIssuer;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;
import java.util.List;

class BatchExecutor<RequestT, ResponseT>
implements ThresholdBatchReceiver<Batch<RequestT, ResponseT>> {
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final PartitionKey partitionKey;

    public BatchExecutor(BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, PartitionKey partitionKey) {
        this.batchingDescriptor = (BatchingDescriptor)Preconditions.checkNotNull(batchingDescriptor);
        this.partitionKey = (PartitionKey)Preconditions.checkNotNull((Object)partitionKey);
    }

    public void validateBatch(Batch<RequestT, ResponseT> item) {
        PartitionKey itemPartitionKey = this.batchingDescriptor.getBatchPartitionKey(item.getRequest());
        if (!itemPartitionKey.equals((Object)this.partitionKey)) {
            String requestClassName = item.getRequest().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("For type %s, invalid partition key: %s, should be: %s", requestClassName, itemPartitionKey, this.partitionKey));
        }
    }

    public ApiFuture<ResponseT> processBatch(Batch<RequestT, ResponseT> batch) {
        UnaryCallable<RequestT, ResponseT> callable = batch.getCallable();
        RequestT request = batch.getRequest();
        final List<BatchedRequestIssuer<ResponseT>> requestIssuerList = batch.getRequestIssuerList();
        ApiFuture<ResponseT> future = callable.futureCall(request);
        ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<ResponseT>(){

            public void onSuccess(ResponseT result) {
                BatchExecutor.this.batchingDescriptor.splitResponse(result, requestIssuerList);
                for (BatchedRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }

            public void onFailure(Throwable t) {
                BatchExecutor.this.batchingDescriptor.splitException(t, requestIssuerList);
                for (BatchedRequestIssuer requestIssuer : requestIssuerList) {
                    requestIssuer.sendResult();
                }
            }
        });
        return future;
    }
}

