/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;

@BetaApi
public final class OperationCallSettings<RequestT, ResponseT extends Message, MetadataT extends Message> {
    private final SimpleCallSettings<RequestT, Operation> initialCallSettings;
    private final TimedRetryAlgorithm pollingAlgorithm;
    private final Class<ResponseT> responseClass;
    private final Class<MetadataT> metadataClass;

    public final SimpleCallSettings<RequestT, Operation> getInitialCallSettings() {
        return this.initialCallSettings;
    }

    public final TimedRetryAlgorithm getPollingAlgorithm() {
        return this.pollingAlgorithm;
    }

    public Class<ResponseT> getResponseClass() {
        return this.responseClass;
    }

    public Class<MetadataT> getMetadataClass() {
        return this.metadataClass;
    }

    private OperationCallSettings(SimpleCallSettings<RequestT, Operation> initialCallSettings, TimedRetryAlgorithm pollingAlgorithm, Class<ResponseT> responseClass, Class<MetadataT> metadataClass) {
        this.initialCallSettings = (SimpleCallSettings)Preconditions.checkNotNull(initialCallSettings);
        this.pollingAlgorithm = (TimedRetryAlgorithm)Preconditions.checkNotNull((Object)pollingAlgorithm);
        this.responseClass = (Class)Preconditions.checkNotNull(responseClass);
        this.metadataClass = metadataClass;
    }

    public static <RequestT, ResponseT extends Message, MetadataT extends Message> Builder<RequestT, ResponseT, MetadataT> newBuilder() {
        return new Builder();
    }

    public final Builder<RequestT, ResponseT, MetadataT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT extends Message, MetadataT extends Message> {
        private SimpleCallSettings<RequestT, Operation> initialCallSettings;
        private TimedRetryAlgorithm pollingAlgorithm;
        private Class<ResponseT> responseClass;
        private Class<MetadataT> metadataClass;

        public Builder() {
        }

        public Builder(OperationCallSettings<RequestT, ResponseT, MetadataT> settings) {
            this.initialCallSettings = ((SimpleCallSettings.Builder)((OperationCallSettings)settings).initialCallSettings.toBuilder()).build();
            this.pollingAlgorithm = ((OperationCallSettings)settings).pollingAlgorithm;
            this.responseClass = ((OperationCallSettings)settings).responseClass;
            this.metadataClass = ((OperationCallSettings)settings).metadataClass;
        }

        public Builder<RequestT, ResponseT, MetadataT> setPollingAlgorithm(TimedRetryAlgorithm pollingAlgorithm) {
            this.pollingAlgorithm = pollingAlgorithm;
            return this;
        }

        public TimedRetryAlgorithm getPollingAlgorithm() {
            return this.pollingAlgorithm;
        }

        public Builder<RequestT, ResponseT, MetadataT> setInitialCallSettings(SimpleCallSettings<RequestT, Operation> initialCallSettings) {
            this.initialCallSettings = initialCallSettings;
            return this;
        }

        public SimpleCallSettings<RequestT, Operation> getInitialCallSettings() {
            return this.initialCallSettings;
        }

        public Class<ResponseT> getResponseClass() {
            return this.responseClass;
        }

        public Builder<RequestT, ResponseT, MetadataT> setResponseClass(Class<ResponseT> responseClass) {
            this.responseClass = responseClass;
            return this;
        }

        public Class<MetadataT> getMetadataClass() {
            return this.metadataClass;
        }

        public Builder<RequestT, ResponseT, MetadataT> setMetadataClass(Class<MetadataT> metadataClass) {
            this.metadataClass = metadataClass;
            return this;
        }

        public OperationCallSettings<RequestT, ResponseT, MetadataT> build() {
            return new OperationCallSettings(this.initialCallSettings, this.pollingAlgorithm, this.responseClass, this.metadataClass);
        }
    }
}

