/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.common.base.Preconditions;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@BetaApi
public final class OperationFuture<ResponseT extends Message, MetadataT extends Message>
implements ApiFuture<ResponseT> {
    private final Object lock = new Object();
    private final RetryingFuture<Operation> pollingFuture;
    private final ApiFuture<Operation> initialFuture;
    private final ApiFuture<ResponseT> resultFuture;
    private final ApiFunction<Operation, MetadataT> metadataTransformer;
    private volatile ApiFuture<Operation> peekedAttemptResult;
    private volatile ApiFuture<MetadataT> peekedPollResult;
    private volatile ApiFuture<Operation> gottenAttemptResult;
    private volatile ApiFuture<MetadataT> gottenPollResult;

    public OperationFuture(RetryingFuture<Operation> pollingFuture, ApiFuture<Operation> initialFuture, ApiFunction<Operation, ResponseT> responseTransformer, ApiFunction<Operation, MetadataT> metadataTransformer) {
        this.pollingFuture = (RetryingFuture)Preconditions.checkNotNull(pollingFuture);
        this.initialFuture = (ApiFuture)Preconditions.checkNotNull(initialFuture);
        this.resultFuture = ApiFutures.transform(pollingFuture, responseTransformer);
        this.metadataTransformer = (ApiFunction)Preconditions.checkNotNull(metadataTransformer);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.pollingFuture.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.pollingFuture.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.pollingFuture.isCancelled();
    }

    public boolean isDone() {
        return this.pollingFuture.isDone();
    }

    public ResponseT get() throws InterruptedException, ExecutionException {
        this.pollingFuture.get();
        return (ResponseT)((Message)this.resultFuture.get());
    }

    public ResponseT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.pollingFuture.get(timeout, unit);
        return (ResponseT)((Message)this.resultFuture.get());
    }

    public String getName() throws ExecutionException, InterruptedException {
        return ((Operation)this.initialFuture.get()).getName();
    }

    public ApiFuture<Operation> getInitialFuture() {
        return this.initialFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<MetadataT> peekMetadata() {
        ApiFuture future = this.pollingFuture.peekAttemptResult();
        Object object = this.lock;
        synchronized (object) {
            if (this.peekedAttemptResult == future) {
                return this.peekedPollResult;
            }
            this.peekedAttemptResult = future;
            this.peekedPollResult = ApiFutures.transform(this.peekedAttemptResult, this.metadataTransformer);
            return this.peekedPollResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<MetadataT> getMetadata() {
        ApiFuture future = this.pollingFuture.getAttemptResult();
        Object object = this.lock;
        synchronized (object) {
            if (this.gottenAttemptResult == future) {
                return this.gottenPollResult;
            }
            this.gottenAttemptResult = future;
            this.gottenPollResult = ApiFutures.transform(this.gottenAttemptResult, this.metadataTransformer);
            return this.gottenPollResult;
        }
    }
}

