/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.ApiExceptions;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.OperationCallSettings;
import com.google.api.gax.grpc.OperationCheckingCallable;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.OperationResponsePollAlgorithm;
import com.google.api.gax.grpc.RetryingCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.common.base.Preconditions;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Status;

@BetaApi
public final class OperationCallable<RequestT, ResponseT extends Message, MetadataT extends Message> {
    private final UnaryCallable<RequestT, Operation> initialCallable;
    private final ClientContext clientContext;
    private final RetryingExecutor<Operation> executor;
    private final OperationsClient operationsClient;
    private final ApiFunction<Operation, ResponseT> responseTransformer;
    private final ApiFunction<Operation, MetadataT> metadataTransformer;

    private OperationCallable(UnaryCallable<RequestT, Operation> initialCallable, ClientContext clientContext, RetryingExecutor<Operation> executor, OperationsClient operationsClient, ApiFunction<Operation, ResponseT> responseTransformer, ApiFunction<Operation, MetadataT> metadataTransformer) {
        this.initialCallable = (UnaryCallable)Preconditions.checkNotNull(initialCallable);
        this.clientContext = (ClientContext)Preconditions.checkNotNull((Object)clientContext);
        this.executor = (RetryingExecutor)Preconditions.checkNotNull(executor);
        this.operationsClient = (OperationsClient)Preconditions.checkNotNull((Object)operationsClient);
        this.responseTransformer = (ApiFunction)Preconditions.checkNotNull(responseTransformer);
        this.metadataTransformer = (ApiFunction)Preconditions.checkNotNull(metadataTransformer);
    }

    public static <RequestT, ResponseT extends Message, MetadataT extends Message> OperationCallable<RequestT, ResponseT, MetadataT> create(OperationCallSettings<RequestT, ResponseT, MetadataT> settings, ClientContext clientContext, OperationsClient operationsClient) {
        UnaryCallable<RequestT, Operation> initialCallable = settings.getInitialCallSettings().create(clientContext);
        RetryAlgorithm pollingAlgorithm = new RetryAlgorithm((ResultRetryAlgorithm)new OperationResponsePollAlgorithm(), settings.getPollingAlgorithm());
        ScheduledRetryingExecutor scheduler = new ScheduledRetryingExecutor(pollingAlgorithm, clientContext.getExecutor());
        return new OperationCallable<RequestT, ResponseT, MetadataT>(initialCallable, clientContext, (RetryingExecutor<Operation>)scheduler, operationsClient, new ResponseTransformer(new AnyTransformer(settings.getResponseClass())), new MetadataTransformer(new AnyTransformer(settings.getMetadataClass())));
    }

    public OperationFuture<ResponseT, MetadataT> futureCall(RequestT request, CallContext context) {
        if (context.getChannel() == null) {
            context = context.withChannel(this.clientContext.getChannel());
        }
        return this.futureCall((RequestT)this.initialCallable.futureCall(request, context));
    }

    OperationFuture<ResponseT, MetadataT> futureCall(ApiFuture<Operation> initialFuture) {
        RetryingCallable<Object, Operation> callable = new RetryingCallable<Object, Operation>(new OperationCheckingCallable(this.operationsClient.getOperationCallable(), initialFuture), this.executor);
        RetryingFuture<Operation> pollingFuture = callable.futureCall((Object)null, (CallContext)null);
        return new OperationFuture<ResponseT, MetadataT>(pollingFuture, initialFuture, this.responseTransformer, this.metadataTransformer);
    }

    public OperationFuture<ResponseT, MetadataT> futureCall(RequestT request) {
        return this.futureCall(request, CallContext.createDefault().withChannel(this.clientContext.getChannel()));
    }

    public ResponseT call(RequestT request, CallContext context) {
        return (ResponseT)((Message)ApiExceptions.callAndTranslateApiException(this.futureCall(request, context)));
    }

    public ResponseT call(RequestT request) {
        return (ResponseT)((Message)ApiExceptions.callAndTranslateApiException(this.futureCall(request)));
    }

    public OperationFuture<ResponseT, MetadataT> resumeFutureCall(String operationName) {
        ApiFuture<Operation> getOperationFuture = this.operationsClient.getOperationCallable().futureCall(GetOperationRequest.newBuilder().setName(operationName).build());
        return this.futureCall((RequestT)getOperationFuture);
    }

    public ApiFuture<Empty> cancel(String operationName) {
        return this.operationsClient.cancelOperationCallable().futureCall(CancelOperationRequest.newBuilder().setName(operationName).build());
    }

    private static class AnyTransformer<PackedT extends Message>
    implements ApiFunction<Any, PackedT> {
        private final Class<PackedT> packedClass;

        private AnyTransformer(Class<PackedT> packedClass) {
            this.packedClass = packedClass;
        }

        public PackedT apply(Any input) {
            try {
                return (PackedT)(input == null || this.packedClass == null ? null : input.unpack(this.packedClass));
            }
            catch (InvalidProtocolBufferException | ClassCastException e) {
                throw new IllegalStateException("Failed to unpack object from 'any' field. Expected " + this.packedClass.getName() + ", found " + input.getTypeUrl());
            }
        }
    }

    private static class MetadataTransformer<MetadataT extends Message>
    implements ApiFunction<Operation, MetadataT> {
        private final AnyTransformer<MetadataT> transformer;

        public MetadataTransformer(AnyTransformer<MetadataT> transformer) {
            this.transformer = transformer;
        }

        public MetadataT apply(Operation input) {
            try {
                return this.transformer.apply(input.hasMetadata() ? input.getMetadata() : null);
            }
            catch (RuntimeException e) {
                throw new ApiException("Polling operation with name \"" + input.getName() + "\" succeeded, but encountered a problem unpacking it.", (Throwable)e, Status.fromCodeValue((int)input.getError().getCode()).getCode(), false);
            }
        }
    }

    private static class ResponseTransformer<ResponseT extends Message>
    implements ApiFunction<Operation, ResponseT> {
        private final AnyTransformer<ResponseT> transformer;

        public ResponseTransformer(AnyTransformer<ResponseT> transformer) {
            this.transformer = transformer;
        }

        public ResponseT apply(Operation input) {
            Status status = Status.fromCodeValue((int)input.getError().getCode());
            if (!status.equals((Object)Status.OK)) {
                throw new ApiException("Operation with name \"" + input.getName() + "\" failed with status = " + status, null, status.getCode(), false);
            }
            try {
                return this.transformer.apply(input.getResponse());
            }
            catch (RuntimeException e) {
                throw new ApiException("Operation with name \"" + input.getName() + "\" succeeded, but encountered a problem unpacking it.", (Throwable)e, status.getCode(), false);
            }
        }
    }
}

