/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.AuthClientCallFactory;
import com.google.api.gax.grpc.ClientCallFactory;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.DescriptorClientCallFactory;
import com.google.api.gax.grpc.DirectStreamingCallable;
import com.google.api.gax.grpc.StreamingCallable;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;

@BetaApi
public final class StreamingCallSettings<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor);
    }

    private StreamingCallSettings(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @Deprecated
    StreamingCallable<RequestT, ResponseT> createStreamingCallable(Channel channel) {
        DescriptorClientCallFactory<RequestT, ResponseT> clientCallFactory = new DescriptorClientCallFactory<RequestT, ResponseT>(this.methodDescriptor);
        StreamingCallable<RequestT, ResponseT> callable = new StreamingCallable<RequestT, ResponseT>(new DirectStreamingCallable<RequestT, ResponseT>(clientCallFactory), channel, this);
        return callable;
    }

    StreamingCallable<RequestT, ResponseT> createStreamingCallable(ClientContext context) {
        ClientCallFactory<RequestT, ResponseT> clientCallFactory = new DescriptorClientCallFactory<RequestT, ResponseT>(this.methodDescriptor);
        if (context.getCredentials() != null) {
            clientCallFactory = new AuthClientCallFactory<RequestT, ResponseT>(clientCallFactory, context.getCredentials());
        }
        StreamingCallable<RequestT, ResponseT> callable = new StreamingCallable<RequestT, ResponseT>(new DirectStreamingCallable<RequestT, ResponseT>(clientCallFactory), context.getChannel(), this);
        return callable;
    }

    public static class Builder<RequestT, ResponseT> {
        private MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor;

        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
            this.grpcMethodDescriptor = grpcMethodDescriptor;
        }

        public Builder(StreamingCallSettings<RequestT, ResponseT> settings) {
            this.grpcMethodDescriptor = settings.getMethodDescriptor();
        }

        public StreamingCallSettings<RequestT, ResponseT> build() {
            return new StreamingCallSettings(this.grpcMethodDescriptor);
        }
    }
}

