/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import java.util.Objects;

@BetaApi
public final class GrpcCallContext
implements ApiCallContext {
    private final Channel channel;
    private final CallOptions callOptions;

    public static GrpcCallContext getAsGrpcCallContextWithDefault(ApiCallContext inputContext) {
        GrpcCallContext grpcCallContext;
        if (inputContext == null) {
            grpcCallContext = GrpcCallContext.createDefault();
        } else {
            if (!(inputContext instanceof GrpcCallContext)) {
                throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputContext.getClass().getName());
            }
            grpcCallContext = (GrpcCallContext)inputContext;
        }
        return grpcCallContext;
    }

    private GrpcCallContext(Channel channel, CallOptions callOptions) {
        this.channel = channel;
        this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions);
    }

    public static GrpcCallContext createDefault() {
        return new GrpcCallContext(null, CallOptions.DEFAULT);
    }

    public static GrpcCallContext of(Channel channel, CallOptions callOptions) {
        return new GrpcCallContext(channel, callOptions);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public CallOptions getCallOptions() {
        return this.callOptions;
    }

    public GrpcCallContext withChannel(Channel channel) {
        return new GrpcCallContext(channel, this.callOptions);
    }

    public GrpcCallContext withCallOptions(CallOptions callOptions) {
        return new GrpcCallContext(this.channel, callOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallContext that = (GrpcCallContext)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.callOptions, that.callOptions);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.callOptions);
    }
}

