/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ApiResultRetryAlgorithm;
import com.google.api.gax.grpc.GrpcAuthCallContextEnhancer;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcChannelCallContextEnhancer;
import com.google.api.gax.grpc.GrpcDirectCallable;
import com.google.api.gax.grpc.GrpcDirectStreamingCallable;
import com.google.api.gax.grpc.GrpcExceptionCallable;
import com.google.api.gax.grpc.GrpcOperationCallableImpl;
import com.google.api.gax.grpc.GrpcRetryingCallable;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.OperationResponsePollAlgorithm;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.api.gax.rpc.BatcherFactory;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.EntryPointOperationCallable;
import com.google.api.gax.rpc.EntryPointStreamingCallable;
import com.google.api.gax.rpc.EntryPointUnaryCallable;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedCallable;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StreamingCallable;
import com.google.api.gax.rpc.UnaryCallSettingsTyped;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@BetaApi
public class GrpcCallableFactory {
    private GrpcCallableFactory() {
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createDirectCallable(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        return new GrpcDirectCallable<RequestT, ResponseT>(methodDescriptor);
    }

    public static <RequestT, ResponseT> StreamingCallable<RequestT, ResponseT> createDirectStreamingCallable(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        return new GrpcDirectStreamingCallable<RequestT, ResponseT>(methodDescriptor);
    }

    static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseCallable(UnaryCallable<RequestT, ResponseT> directCallable, UnaryCallSettingsTyped<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        GrpcExceptionCallable<RequestT, ResponseT> callable = new GrpcExceptionCallable<RequestT, ResponseT>(directCallable, GrpcCallableFactory.getGrpcStatusCodes(callSettings.getRetryableCodes()));
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), clientContext.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor(retryAlgorithm, clientContext.getExecutor());
        return new GrpcRetryingCallable<RequestT, ResponseT>(callable, retryingExecutor);
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> create(UnaryCallable<RequestT, ResponseT> directCallable, SimpleCallSettings<RequestT, ResponseT> simpleCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> unaryCallable = GrpcCallableFactory.createBaseCallable(directCallable, simpleCallSettings, clientContext);
        return new EntryPointUnaryCallable(unaryCallable, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedVariant(UnaryCallable<RequestT, ResponseT> directCallable, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> unaryCallable = GrpcCallableFactory.createBaseCallable(directCallable, pagedCallSettings, clientContext);
        PagedCallable pagedCallable = new PagedCallable(unaryCallable, pagedCallSettings.getPagedListResponseFactory());
        return new EntryPointUnaryCallable((UnaryCallable)pagedCallable, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, ResponseT> create(UnaryCallable<RequestT, ResponseT> directCallable, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> unaryCallable = GrpcCallableFactory.createBaseCallable(directCallable, pagedCallSettings, clientContext);
        return new EntryPointUnaryCallable(unaryCallable, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> create(UnaryCallable<RequestT, ResponseT> directCallable, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext context) {
        return GrpcCallableFactory.internalCreate(directCallable, batchingCallSettings, (ClientContext)context).unaryCallable;
    }

    static <RequestT, ResponseT> BatchingCreateResult<RequestT, ResponseT> internalCreate(UnaryCallable<RequestT, ResponseT> directCallable, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        BatchingCallable callable = GrpcCallableFactory.createBaseCallable(directCallable, batchingCallSettings, clientContext);
        BatcherFactory batcherFactory = new BatcherFactory(batchingCallSettings.getBatchingDescriptor(), batchingCallSettings.getBatchingSettings(), clientContext.getExecutor(), batchingCallSettings.getFlowController());
        callable = new BatchingCallable(callable, batchingCallSettings.getBatchingDescriptor(), batcherFactory);
        callable = new EntryPointUnaryCallable((UnaryCallable)callable, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
        return new BatchingCreateResult(batcherFactory, callable);
    }

    public static <RequestT, ResponseT extends Message, MetadataT extends Message> OperationCallable<RequestT, ResponseT, MetadataT, Operation> create(UnaryCallable<RequestT, Operation> directCallable, OperationCallSettings<RequestT, ResponseT, MetadataT, Operation> operationCallSettings, ClientContext clientContext, OperationsStub operationsStub) {
        GrpcOperationCallableImpl<RequestT, ResponseT, MetadataT> callableImpl = GrpcCallableFactory.createImpl(directCallable, operationCallSettings, clientContext, operationsStub);
        return new EntryPointOperationCallable(callableImpl, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
    }

    static <RequestT, ResponseT extends Message, MetadataT extends Message> GrpcOperationCallableImpl<RequestT, ResponseT, MetadataT> createImpl(UnaryCallable<RequestT, Operation> directCallable, OperationCallSettings<RequestT, ResponseT, MetadataT, Operation> operationCallSettings, ClientContext clientContext, OperationsStub operationsStub) {
        UnaryCallable<RequestT, Operation> initialCallable = GrpcCallableFactory.createBaseCallable(directCallable, operationCallSettings.getInitialCallSettings(), clientContext);
        RetryAlgorithm pollingAlgorithm = new RetryAlgorithm((ResultRetryAlgorithm)new OperationResponsePollAlgorithm(), operationCallSettings.getPollingAlgorithm());
        ScheduledRetryingExecutor scheduler = new ScheduledRetryingExecutor(pollingAlgorithm, clientContext.getExecutor());
        return new GrpcOperationCallableImpl<RequestT, ResponseT, MetadataT>(initialCallable, clientContext, (RetryingExecutor<Operation>)scheduler, operationsStub, operationCallSettings);
    }

    public static <RequestT, ResponseT> StreamingCallable<RequestT, ResponseT> create(StreamingCallable<RequestT, ResponseT> directCallable, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        return new EntryPointStreamingCallable(directCallable, (ApiCallContext)GrpcCallContext.createDefault(), GrpcCallableFactory.getCallContextEnhancers(clientContext));
    }

    private static List<ApiCallContextEnhancer> getCallContextEnhancers(ClientContext clientContext) {
        ArrayList<ApiCallContextEnhancer> enhancers = new ArrayList<ApiCallContextEnhancer>();
        if (clientContext.getCredentials() != null) {
            enhancers.add(new GrpcAuthCallContextEnhancer(clientContext.getCredentials()));
        }
        if (GrpcCallableFactory.isGrpc(clientContext)) {
            GrpcTransport transportContext = (GrpcTransport)clientContext.getTransportContext();
            enhancers.add(new GrpcChannelCallContextEnhancer(transportContext.getChannel()));
        }
        return enhancers;
    }

    private static Set<Status.Code> getGrpcStatusCodes(Set<StatusCode> statusCodes) {
        HashSet<Status.Code> returnCodes = new HashSet<Status.Code>();
        for (StatusCode code : statusCodes) {
            if (!(code instanceof GrpcStatusCode)) continue;
            returnCodes.add(((GrpcStatusCode)code).getCode());
        }
        return returnCodes;
    }

    private static boolean isGrpc(ClientContext context) {
        return context.getTransportContext().getTransportName().equals(GrpcTransport.getGrpcTransportName());
    }

    static class BatchingCreateResult<RequestT, ResponseT> {
        BatcherFactory<RequestT, ResponseT> batcherFactory;
        UnaryCallable<RequestT, ResponseT> unaryCallable;

        BatchingCreateResult(BatcherFactory<RequestT, ResponseT> batcherFactory, UnaryCallable<RequestT, ResponseT> unaryCallable) {
            this.batcherFactory = batcherFactory;
            this.unaryCallable = unaryCallable;
        }
    }
}

