/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.StreamingCallable;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

class GrpcDirectStreamingCallable<RequestT, ResponseT>
extends StreamingCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;

    GrpcDirectStreamingCallable(MethodDescriptor<RequestT, ResponseT> descriptor) {
        this.descriptor = (MethodDescriptor)Preconditions.checkNotNull(descriptor);
    }

    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.newCall(context);
        ClientCalls.asyncServerStreamingCall(call, request, new ApiStreamObserverDelegate<ResponseT>(responseObserver));
    }

    public Iterator<ResponseT> blockingServerStreamingCall(RequestT request, ApiCallContext context) {
        Preconditions.checkNotNull(request);
        ClientCall<RequestT, ResponseT> call = this.newCall(context);
        return ClientCalls.blockingServerStreamingCall(call, request);
    }

    public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.newCall(context);
        return new StreamObserverDelegate(ClientCalls.asyncBidiStreamingCall(call, new ApiStreamObserverDelegate<ResponseT>(responseObserver)));
    }

    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.newCall(context);
        return new StreamObserverDelegate(ClientCalls.asyncClientStreamingCall(call, new ApiStreamObserverDelegate<ResponseT>(responseObserver)));
    }

    public ClientCall<RequestT, ResponseT> newCall(ApiCallContext context) {
        if (!(context instanceof GrpcCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + context.getClass().getName());
        }
        GrpcCallContext grpcContext = (GrpcCallContext)context;
        Preconditions.checkNotNull((Object)grpcContext.getChannel());
        Preconditions.checkNotNull((Object)grpcContext.getCallOptions());
        return grpcContext.getChannel().newCall(this.descriptor, grpcContext.getCallOptions());
    }

    private static class StreamObserverDelegate<V>
    implements ApiStreamObserver<V> {
        private final StreamObserver<V> delegate;

        public StreamObserverDelegate(StreamObserver<V> delegate) {
            this.delegate = delegate;
        }

        public void onNext(V v) {
            this.delegate.onNext(v);
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
        }
    }

    private static class ApiStreamObserverDelegate<V>
    implements StreamObserver<V> {
        private final ApiStreamObserver<V> delegate;

        public ApiStreamObserverDelegate(ApiStreamObserver<V> delegate) {
            this.delegate = delegate;
        }

        public void onNext(V v) {
            this.delegate.onNext(v);
        }

        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
        }
    }
}

