/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

class GrpcHeaderInterceptor
implements ClientInterceptor {
    private static final Metadata.Key<String> HEADER_KEY = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final String header;

    public GrpcHeaderInterceptor(String header) {
        this.header = header;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall call = next.newCall(method, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(HEADER_KEY, (Object)GrpcHeaderInterceptor.this.header);
                super.start(responseListener, headers);
            }
        };
    }
}

