/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcApiExceptionFactory;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Set;
import java.util.concurrent.CancellationException;

class GrpcExceptionCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<Status.Code> retryableCodes;

    GrpcExceptionCallable(UnaryCallable<RequestT, ResponseT> callable, Set<Status.Code> retryableCodes) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = ImmutableSet.copyOf(retryableCodes);
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        GrpcCallContext context = GrpcCallContext.getAsGrpcCallContextWithDefault(inputContext);
        ApiFuture innerCallFuture = this.callable.futureCall(request, (ApiCallContext)context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback((ApiFuture)innerCallFuture, (ApiFutureCallback)transformingFuture);
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            boolean canRetry;
            Status.Code statusCode;
            if (throwable instanceof StatusException) {
                StatusException e = (StatusException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = GrpcExceptionCallable.this.retryableCodes.contains((Object)statusCode);
            } else if (throwable instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = GrpcExceptionCallable.this.retryableCodes.contains((Object)statusCode);
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                statusCode = Status.Code.UNKNOWN;
                canRetry = false;
            }
            super.setException((Throwable)GrpcApiExceptionFactory.createException(throwable, statusCode, canRetry));
        }
    }
}

