/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.api.gax.grpc.testing.FakeServiceImpl;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannel;
import com.google.common.truth.Truth;
import com.google.type.Color;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class GrpcCallableFactoryTest {
    private InProcessServer<FakeServiceImpl> inprocessServer;
    private ManagedChannel channel;
    private ClientContext clientContext;

    @Before
    public void setUp() throws Exception {
        String serverName = "fakeservice";
        FakeServiceImpl serviceImpl = new FakeServiceImpl();
        this.inprocessServer = new InProcessServer<FakeServiceImpl>(serviceImpl, serverName);
        this.inprocessServer.start();
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).usePlaintext().build();
        this.clientContext = ClientContext.newBuilder().setTransportChannel((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.channel)).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)this.channel, (CallOptions)CallOptions.DEFAULT)).build();
    }

    @After
    public void tearDown() {
        this.channel.shutdown();
        this.inprocessServer.stop();
    }

    @Test
    public void createServerStreamingCallableRetryableExceptions() throws Exception {
        GrpcCallSettings grpcCallSettings = GrpcCallSettings.create(FakeServiceGrpc.METHOD_STREAMING_RECOGNIZE_ERROR);
        ServerStreamingCallSettings nonRetryableSettings = ServerStreamingCallSettings.newBuilder().setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ofSeconds((long)1L)).setMaxAttempts(1).build()).build();
        ServerStreamingCallable nonRetryableCallable = GrpcCallableFactory.createServerStreamingCallable((GrpcCallSettings)grpcCallSettings, (ServerStreamingCallSettings)nonRetryableSettings, (ClientContext)this.clientContext);
        Throwable actualError = null;
        try {
            nonRetryableCallable.first().call((Object)Color.getDefaultInstance(), this.clientContext.getDefaultCallContext());
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(InvalidArgumentException.class);
        Truth.assertThat((Boolean)((InvalidArgumentException)actualError).isRetryable()).isFalse();
        ServerStreamingCallSettings retryableSettings = ServerStreamingCallSettings.newBuilder().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.INVALID_ARGUMENT}).setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(Duration.ofSeconds((long)1L)).setMaxAttempts(1).build()).build();
        ServerStreamingCallable retryableCallable = GrpcCallableFactory.createServerStreamingCallable((GrpcCallSettings)grpcCallSettings, (ServerStreamingCallSettings)retryableSettings, (ClientContext)this.clientContext);
        Throwable actualError2 = null;
        try {
            retryableCallable.first().call((Object)Color.getDefaultInstance(), this.clientContext.getDefaultCallContext());
        }
        catch (Throwable e) {
            actualError2 = e;
        }
        Truth.assertThat((Throwable)actualError2).isInstanceOf(InvalidArgumentException.class);
        Truth.assertThat((Boolean)((InvalidArgumentException)actualError2).isRetryable()).isTrue();
    }
}

