/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiClock;
import com.google.api.core.ApiFunction;
import com.google.api.gax.core.FakeApiClock;
import com.google.api.gax.core.RecordingScheduler;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.MockClientCall;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.grpc.testing.FakeMethodDescriptor;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.truth.Truth;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.longrunning.stub.OperationsStubSettings;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class GrpcLongRunningTest {
    private static final RetrySettings FAST_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofMillis((long)1L)).setInitialRpcTimeout(Duration.ofMillis((long)1L)).setMaxAttempts(0).setJittered(false).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)1L)).setTotalTimeout(Duration.ofMillis((long)5L)).build();
    private ManagedChannel channel;
    private OperationsStub operationsStub;
    private RecordingScheduler executor;
    private ClientContext initialContext;
    private OperationCallSettings<Integer, Color, Money> callSettings;
    private FakeApiClock clock;
    private OperationTimedPollAlgorithm pollingAlgorithm;

    @Before
    public void setUp() throws IOException {
        this.channel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        TransportChannelProvider operationsChannelProvider = (TransportChannelProvider)Mockito.mock(TransportChannelProvider.class);
        GrpcTransportChannel transportChannel = GrpcTransportChannel.newBuilder().setManagedChannel(this.channel).build();
        Mockito.when((Object)operationsChannelProvider.getTransportChannel()).thenReturn((Object)transportChannel);
        this.clock = new FakeApiClock(0L);
        this.executor = RecordingScheduler.create((FakeApiClock)this.clock);
        this.pollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)FAST_RETRY_SETTINGS, (ApiClock)this.clock);
        OperationsSettings.Builder settingsBuilder = OperationsSettings.newBuilder();
        settingsBuilder.getOperationSettings().setRetrySettings(FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(1).build());
        OperationsSettings settings = ((OperationsSettings.Builder)OperationsSettings.newBuilder().setTransportChannelProvider(operationsChannelProvider)).build();
        this.operationsStub = GrpcOperationsStub.create((OperationsStubSettings)((OperationsStubSettings)settings.getStubSettings()));
        UnaryCallSettings initialCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(FAST_RETRY_SETTINGS.toBuilder().setMaxAttempts(1).build()).build();
        this.callSettings = OperationCallSettings.newBuilder().setInitialCallSettings(initialCallSettings).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Color.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Money.class)).setPollingAlgorithm((TimedRetryAlgorithm)this.pollingAlgorithm).build();
        this.initialContext = ClientContext.newBuilder().setTransportChannel((TransportChannel)GrpcTransportChannel.newBuilder().setManagedChannel(this.channel).build()).setExecutor((ScheduledExecutorService)this.executor).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)this.channel, (CallOptions)CallOptions.DEFAULT)).setClock((ApiClock)this.clock).build();
    }

    @Test
    public void testCall() {
        Color resp = this.getColor(1.0f);
        Money meta = this.getMoney("UAH");
        Operation resultOperation = this.getOperation("testCall", (Message)resp, (Message)meta, true);
        this.mockResponse(this.channel, Status.Code.OK, resultOperation);
        OperationCallable callable = GrpcCallableFactory.createOperationCallable(this.createGrpcSettings(), this.callSettings, (ClientContext)this.initialContext, (OperationsStub)this.operationsStub);
        Color response = (Color)callable.call((Object)2, (ApiCallContext)GrpcCallContext.createDefault());
        Truth.assertThat((Object)response).isEqualTo((Object)resp);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    @Test
    public void testFutureCallPollDoneOnFirst() throws Exception {
        String opName = "testFutureCallPollDoneOnFirst";
        Color resp = this.getColor(0.5f);
        Money meta = this.getMoney("UAH");
        Operation initialOperation = this.getOperation(opName, null, null, false);
        Operation resultOperation = this.getOperation(opName, (Message)resp, (Message)meta, true);
        this.mockResponse(this.channel, Status.Code.OK, initialOperation, resultOperation);
        OperationCallable callable = GrpcCallableFactory.createOperationCallable(this.createGrpcSettings(), this.callSettings, (ClientContext)this.initialContext, (OperationsStub)this.operationsStub);
        OperationFuture future = callable.futureCall((Object)2);
        this.assertFutureSuccessMetaSuccess(opName, (OperationFuture<Color, Money>)future, resp, meta);
        Truth.assertThat((Integer)this.executor.getIterationsCount()).isEqualTo((Object)0);
    }

    private void assertFutureSuccessMetaSuccess(String opName, OperationFuture<Color, Money> future, Color resp, Money meta) throws Exception {
        Truth.assertThat((String)future.getName()).isEqualTo((Object)opName);
        Truth.assertThat((Object)future.get(3L, TimeUnit.SECONDS)).isEqualTo((Object)resp);
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        Truth.assertThat((Object)future.get()).isEqualTo((Object)resp);
        Truth.assertThat((Object)future.peekMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.peekMetadata()).isSameAs((Object)future.peekMetadata());
        Truth.assertThat((Boolean)future.peekMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.peekMetadata().isCancelled()).isFalse();
        Truth.assertThat((Object)future.getMetadata().get()).isEqualTo((Object)meta);
        Truth.assertThat((Object)future.getMetadata()).isSameAs((Object)future.getMetadata());
        Truth.assertThat((Boolean)future.getMetadata().isDone()).isTrue();
        Truth.assertThat((Boolean)future.getMetadata().isCancelled()).isFalse();
    }

    private Color getColor(float blueValue) {
        return Color.newBuilder().setBlue(blueValue).build();
    }

    private Money getMoney(String currencyCode) {
        return Money.newBuilder().setCurrencyCode(currencyCode).build();
    }

    private Operation getOperation(String name, Message response, Message metadata, boolean done) {
        Operation.Builder builder = Operation.newBuilder().setName(name).setDone(done);
        if (response instanceof com.google.rpc.Status) {
            builder.setError((com.google.rpc.Status)response);
        } else if (response != null) {
            builder.setResponse(Any.pack((Message)response));
        }
        if (metadata != null) {
            builder.setMetadata(Any.pack((Message)metadata));
        }
        return builder.build();
    }

    private void mockResponse(ManagedChannel channel, Status.Code statusCode, Object ... results) {
        Status status = statusCode.toStatus();
        MockClientCall clientCall = new MockClientCall(results[0], status);
        Object[] moreCalls = new ClientCall[results.length - 1];
        for (int i = 0; i < results.length - 1; ++i) {
            moreCalls[i] = new MockClientCall(results[i + 1], status);
        }
        Mockito.when((Object)channel.newCall((MethodDescriptor)ArgumentMatchers.any(MethodDescriptor.class), (CallOptions)ArgumentMatchers.any(CallOptions.class))).thenReturn(clientCall, moreCalls);
    }

    private GrpcCallSettings<Integer, Operation> createGrpcSettings() {
        return GrpcCallSettings.create(FakeMethodDescriptor.create());
    }
}

