/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.common.collect.Lists;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.MockOperations;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OperationsClientTest {
    private static MockOperations mockOperations;
    private static MockServiceHelper serviceHelper;
    private OperationsClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockOperations = new MockOperations();
        serviceHelper = new MockServiceHelper("in-process-1", Arrays.asList(mockOperations));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        OperationsSettings settings = ((OperationsSettings.Builder)((OperationsSettings.Builder)OperationsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = OperationsClient.create((OperationsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void getOperationTest() {
        String name2 = "name2-1052831874";
        boolean done = true;
        Operation expectedResponse = Operation.newBuilder().setName(name2).setDone(done).build();
        mockOperations.addResponse((GeneratedMessageV3)expectedResponse);
        String name = "name3373707";
        Operation actualResponse = this.client.getOperation(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<GeneratedMessageV3> actualRequests = mockOperations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetOperationRequest actualRequest = (GetOperationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
    }

    @Test
    public void getOperationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockOperations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getOperation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listOperationsTest() {
        String nextPageToken = "";
        Operation operationsElement = Operation.newBuilder().build();
        List<Operation> operations = Arrays.asList(operationsElement);
        ListOperationsResponse expectedResponse = ListOperationsResponse.newBuilder().setNextPageToken(nextPageToken).addAllOperations(operations).build();
        mockOperations.addResponse((GeneratedMessageV3)expectedResponse);
        String name = "name3373707";
        String filter = "filter-1274492040";
        OperationsClient.ListOperationsPagedResponse pagedListResponse = this.client.listOperations(name, filter);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<GeneratedMessageV3> actualRequests = mockOperations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListOperationsRequest actualRequest = (ListOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)filter, (Object)actualRequest.getFilter());
    }

    @Test
    public void listOperationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockOperations.addException((Exception)exception);
        try {
            String name = "name3373707";
            String filter = "filter-1274492040";
            this.client.listOperations(name, filter);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void cancelOperationTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockOperations.addResponse((GeneratedMessageV3)expectedResponse);
        String name = "name3373707";
        this.client.cancelOperation(name);
        List<GeneratedMessageV3> actualRequests = mockOperations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CancelOperationRequest actualRequest = (CancelOperationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
    }

    @Test
    public void cancelOperationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockOperations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.cancelOperation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteOperationTest() {
        Empty expectedResponse = Empty.newBuilder().build();
        mockOperations.addResponse((GeneratedMessageV3)expectedResponse);
        String name = "name3373707";
        this.client.deleteOperation(name);
        List<GeneratedMessageV3> actualRequests = mockOperations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteOperationRequest actualRequest = (DeleteOperationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
    }

    @Test
    public void deleteOperationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockOperations.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteOperation(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

