/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.testing.FakeMethodDescriptor;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class GrpcHeaderInterceptorTest {
    @Mock
    private Channel channel;
    @Mock
    private ClientCall<String, Integer> call;
    private static final MethodDescriptor<String, Integer> method = FakeMethodDescriptor.create();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.channel.newCall((MethodDescriptor)Mockito.any(), (CallOptions)ArgumentMatchers.any(CallOptions.class))).thenReturn(this.call);
    }

    @Test
    public void testInterceptor() {
        Map<String, String> data = Collections.singletonMap("x-goog-api-client", "abcd");
        GrpcHeaderInterceptor interceptor = new GrpcHeaderInterceptor(data);
        Channel intercepted = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        ClientCall interceptedCall = intercepted.newCall(method, CallOptions.DEFAULT);
        interceptedCall.start(listener, new Metadata());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Metadata.class);
        ((ClientCall)Mockito.verify(this.call)).start((ClientCall.Listener)ArgumentMatchers.same((Object)listener), (Metadata)captor.capture());
        Metadata.Key headerKey = Metadata.Key.of((String)"x-goog-api-client", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Assert.assertEquals((Object)"abcd", (Object)((Metadata)captor.getValue()).get(headerKey));
    }
}

