/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeChannel;
import com.google.api.gax.rpc.testing.FakeTransportChannel;
import com.google.api.gax.tracing.ApiTracer;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import io.grpc.CallOptions;
import io.grpc.ManagedChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class GrpcCallContextTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNullToSelfWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        GrpcCallContext.createDefault().nullToSelf((ApiCallContext)FakeCallContext.createDefault());
    }

    @Test
    public void testWithCredentials() {
        Credentials credentials = (Credentials)Mockito.mock(Credentials.class);
        GrpcCallContext emptyContext = GrpcCallContext.createDefault();
        Truth.assertThat((Object)emptyContext.getCallOptions().getCredentials()).isNull();
        GrpcCallContext context = emptyContext.withCredentials(credentials);
        Truth.assertThat((Object)context.getCallOptions().getCredentials()).isNotNull();
    }

    @Test
    public void testWithTransportChannel() {
        ManagedChannel channel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        GrpcCallContext context = GrpcCallContext.createDefault().withTransportChannel((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
        Truth.assertThat((Object)context.getChannel()).isSameAs((Object)channel);
    }

    @Test
    public void testWithTransportChannelWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        FakeChannel channel = new FakeChannel();
        GrpcCallContext.createDefault().withTransportChannel((TransportChannel)FakeTransportChannel.create((FakeChannel)channel));
    }

    @Test
    public void testMergeWrongType() {
        this.thrown.expect(IllegalArgumentException.class);
        GrpcCallContext.createDefault().merge((ApiCallContext)FakeCallContext.createDefault());
    }

    @Test
    public void testWithRequestParamsDynamicHeaderOption() {
        String encodedRequestParams = "param1=value&param2.param3=value23";
        GrpcCallContext context = GrpcCallContext.createDefault().withRequestParamsDynamicHeaderOption(encodedRequestParams);
        Map headers = CallOptionsUtil.getDynamicHeadersOption((CallOptions)context.getCallOptions());
        Assert.assertEquals((Object)ImmutableMap.of((Object)CallOptionsUtil.REQUEST_PARAMS_HEADER_KEY, (Object)encodedRequestParams), (Object)headers);
    }

    @Test
    public void testWithTimeout() {
        Truth.assertThat((Comparable)GrpcCallContext.createDefault().withTimeout(null).getTimeout()).isNull();
    }

    @Test
    public void testWithNegativeTimeout() {
        Truth.assertThat((Comparable)GrpcCallContext.createDefault().withTimeout(Duration.ofSeconds((long)-1L)).getTimeout()).isNull();
    }

    @Test
    public void testWithZeroTimeout() {
        Truth.assertThat((Comparable)GrpcCallContext.createDefault().withTimeout(Duration.ofSeconds((long)0L)).getTimeout()).isNull();
    }

    @Test
    public void testWithShorterTimeout() {
        GrpcCallContext ctxWithLongTimeout = GrpcCallContext.createDefault().withTimeout(Duration.ofSeconds((long)10L));
        Truth.assertThat((Comparable)ctxWithLongTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)10L));
        GrpcCallContext ctxWithShorterTimeout = ctxWithLongTimeout.withTimeout(Duration.ofSeconds((long)5L));
        Truth.assertThat((Comparable)ctxWithShorterTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
    }

    @Test
    public void testWithLongerTimeout() {
        GrpcCallContext ctxWithShortTimeout = GrpcCallContext.createDefault().withTimeout(Duration.ofSeconds((long)5L));
        Truth.assertThat((Comparable)ctxWithShortTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
        GrpcCallContext ctxWithUnchangedTimeout = ctxWithShortTimeout.withTimeout(Duration.ofSeconds((long)10L));
        Truth.assertThat((Comparable)ctxWithUnchangedTimeout.getTimeout()).isEqualTo((Object)Duration.ofSeconds((long)5L));
    }

    @Test
    public void testMergeWithNullTimeout() {
        Duration timeout = Duration.ofSeconds((long)10L);
        GrpcCallContext baseContext = GrpcCallContext.createDefault().withTimeout(timeout);
        GrpcCallContext defaultOverlay = GrpcCallContext.createDefault();
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)defaultOverlay).getTimeout()).isEqualTo((Object)timeout);
        GrpcCallContext explicitNullOverlay = GrpcCallContext.createDefault().withTimeout(null);
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)explicitNullOverlay).getTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithTimeout() {
        Duration timeout = Duration.ofSeconds((long)19L);
        GrpcCallContext ctx1 = GrpcCallContext.createDefault();
        GrpcCallContext ctx2 = GrpcCallContext.createDefault().withTimeout(timeout);
        Truth.assertThat((Comparable)ctx1.merge((ApiCallContext)ctx2).getTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testWithStreamingWaitTimeout() {
        Duration timeout = Duration.ofSeconds((long)15L);
        GrpcCallContext context = GrpcCallContext.createDefault().withStreamWaitTimeout(timeout);
        Truth.assertThat((Comparable)context.getStreamWaitTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithNullStreamingWaitTimeout() {
        Duration timeout = Duration.ofSeconds((long)10L);
        GrpcCallContext baseContext = GrpcCallContext.createDefault().withStreamWaitTimeout(timeout);
        GrpcCallContext defaultOverlay = GrpcCallContext.createDefault();
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)defaultOverlay).getStreamWaitTimeout()).isEqualTo((Object)timeout);
        GrpcCallContext explicitNullOverlay = GrpcCallContext.createDefault().withStreamWaitTimeout(null);
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)explicitNullOverlay).getStreamWaitTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testWithZeroStreamingWaitTimeout() {
        Duration timeout = Duration.ZERO;
        Truth.assertThat((Comparable)GrpcCallContext.createDefault().withStreamWaitTimeout(timeout).getStreamWaitTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithStreamingWaitTimeout() {
        Duration timeout = Duration.ofSeconds((long)19L);
        GrpcCallContext ctx1 = GrpcCallContext.createDefault();
        GrpcCallContext ctx2 = GrpcCallContext.createDefault().withStreamWaitTimeout(timeout);
        Truth.assertThat((Comparable)ctx1.merge((ApiCallContext)ctx2).getStreamWaitTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testWithStreamingIdleTimeout() {
        Duration timeout = Duration.ofSeconds((long)15L);
        GrpcCallContext context = GrpcCallContext.createDefault().withStreamIdleTimeout(timeout);
        Truth.assertThat((Comparable)context.getStreamIdleTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithNullStreamingIdleTimeout() {
        Duration timeout = Duration.ofSeconds((long)10L);
        GrpcCallContext baseContext = GrpcCallContext.createDefault().withStreamIdleTimeout(timeout);
        GrpcCallContext defaultOverlay = GrpcCallContext.createDefault();
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)defaultOverlay).getStreamIdleTimeout()).isEqualTo((Object)timeout);
        GrpcCallContext explicitNullOverlay = GrpcCallContext.createDefault().withStreamIdleTimeout(null);
        Truth.assertThat((Comparable)baseContext.merge((ApiCallContext)explicitNullOverlay).getStreamIdleTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testWithZeroStreamingIdleTimeout() {
        Duration timeout = Duration.ZERO;
        Truth.assertThat((Comparable)GrpcCallContext.createDefault().withStreamIdleTimeout(timeout).getStreamIdleTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithStreamingIdleTimeout() {
        Duration timeout = Duration.ofSeconds((long)19L);
        GrpcCallContext ctx1 = GrpcCallContext.createDefault();
        GrpcCallContext ctx2 = GrpcCallContext.createDefault().withStreamIdleTimeout(timeout);
        Truth.assertThat((Comparable)ctx1.merge((ApiCallContext)ctx2).getStreamIdleTimeout()).isEqualTo((Object)timeout);
    }

    @Test
    public void testMergeWithCustomCallOptions() {
        CallOptions.Key key = CallOptions.Key.createWithDefault((String)"somekey", (Object)"somedefault");
        GrpcCallContext ctx1 = GrpcCallContext.createDefault();
        GrpcCallContext ctx2 = GrpcCallContext.createDefault().withCallOptions(CallOptions.DEFAULT.withOption(key, (Object)"somevalue"));
        GrpcCallContext merged = (GrpcCallContext)ctx1.merge((ApiCallContext)ctx2);
        Truth.assertThat((String)((String)merged.getCallOptions().getOption(key))).isNotEqualTo(ctx1.getCallOptions().getOption(key));
        Truth.assertThat((String)((String)merged.getCallOptions().getOption(key))).isEqualTo(ctx2.getCallOptions().getOption(key));
    }

    @Test
    public void testWithExtraHeaders() {
        Map<String, List<String>> extraHeaders = GrpcCallContextTest.createTestExtraHeaders("key1", "value1", "key1", "value2");
        GrpcCallContext ctx = GrpcCallContext.createDefault().withExtraHeaders(extraHeaders);
        Map<String, List<String>> moreExtraHeaders = GrpcCallContextTest.createTestExtraHeaders("key1", "value2", "key2", "value2");
        ctx = ctx.withExtraHeaders(moreExtraHeaders);
        Map gotExtraHeaders = ctx.getExtraHeaders();
        Map<String, List<String>> expectedExtraHeaders = GrpcCallContextTest.createTestExtraHeaders("key1", "value1", "key1", "value2", "key1", "value2", "key2", "value2");
        Truth.assertThat((Map)gotExtraHeaders).containsExactlyEntriesIn(expectedExtraHeaders);
    }

    @Test
    public void testMergeWithExtraHeaders() {
        Map<String, List<String>> extraHeaders1 = GrpcCallContextTest.createTestExtraHeaders("key1", "value1", "key1", "value2");
        GrpcCallContext ctx1 = GrpcCallContext.createDefault().withExtraHeaders(extraHeaders1);
        Map<String, List<String>> extraHeaders2 = GrpcCallContextTest.createTestExtraHeaders("key1", "value2", "key2", "value2");
        GrpcCallContext ctx2 = GrpcCallContext.createDefault().withExtraHeaders(extraHeaders2);
        ApiCallContext mergedApiCallContext = ctx1.merge((ApiCallContext)ctx2);
        Truth.assertThat((Object)mergedApiCallContext).isInstanceOf(GrpcCallContext.class);
        GrpcCallContext mergedGrpcCallContext = (GrpcCallContext)mergedApiCallContext;
        Map gotExtraHeaders = mergedGrpcCallContext.getExtraHeaders();
        Map<String, List<String>> expectedExtraHeaders = GrpcCallContextTest.createTestExtraHeaders("key1", "value1", "key1", "value2", "key1", "value2", "key2", "value2");
        Truth.assertThat((Map)gotExtraHeaders).containsExactlyEntriesIn(expectedExtraHeaders);
    }

    @Test
    public void testMergeWithTracer() {
        ApiTracer explicitTracer = (ApiTracer)Mockito.mock(ApiTracer.class);
        GrpcCallContext ctxWithExplicitTracer = GrpcCallContext.createDefault().withTracer(explicitTracer);
        GrpcCallContext ctxWithDefaultTracer = GrpcCallContext.createDefault();
        ApiTracer defaultTracer = ctxWithDefaultTracer.getTracer();
        Truth.assertThat((Object)ctxWithDefaultTracer.merge((ApiCallContext)ctxWithExplicitTracer).getTracer()).isSameAs((Object)explicitTracer);
        Truth.assertThat((Object)ctxWithExplicitTracer.merge((ApiCallContext)ctxWithDefaultTracer).getTracer()).isSameAs((Object)explicitTracer);
        Truth.assertThat((Object)ctxWithDefaultTracer.merge((ApiCallContext)GrpcCallContext.createDefault()).getTracer()).isSameAs((Object)defaultTracer);
    }

    private static Map<String, List<String>> createTestExtraHeaders(String ... keyValues) {
        HashMap<String, List<String>> extraHeaders = new HashMap<String, List<String>>();
        for (int i = 0; i < keyValues.length; i += 2) {
            String key = keyValues[i];
            String value = keyValues[i + 1];
            if (!extraHeaders.containsKey(key)) {
                extraHeaders.put(key, new ArrayList());
            }
            ((List)extraHeaders.get(key)).add(value);
        }
        return extraHeaders;
    }
}

