/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ChannelPool;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcClientCalls;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.threeten.bp.Duration;

public class GrpcClientCallsTest {
    @Test
    public void testAffinity() {
        MethodDescriptor<Color, Money> descriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        ClientCall clientCall0 = (ClientCall)Mockito.mock(ClientCall.class);
        ClientCall clientCall1 = (ClientCall)Mockito.mock(ClientCall.class);
        ManagedChannel channel0 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        ManagedChannel channel1 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        Mockito.when((Object)channel0.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)Mockito.any())).thenReturn((Object)clientCall0);
        Mockito.when((Object)channel1.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)Mockito.any())).thenReturn((Object)clientCall1);
        ChannelPool pool = new ChannelPool(Arrays.asList(channel0, channel1));
        GrpcCallContext context = GrpcCallContext.createDefault().withChannel((Channel)pool);
        ClientCall gotCallA = GrpcClientCalls.newCall(descriptor, (ApiCallContext)context.withChannelAffinity(Integer.valueOf(0)));
        ClientCall gotCallB = GrpcClientCalls.newCall(descriptor, (ApiCallContext)context.withChannelAffinity(Integer.valueOf(0)));
        ClientCall gotCallC = GrpcClientCalls.newCall(descriptor, (ApiCallContext)context.withChannelAffinity(Integer.valueOf(1)));
        Truth.assertThat((Object)gotCallA).isSameAs((Object)gotCallB);
        Truth.assertThat((Object)gotCallA).isNotSameAs((Object)gotCallC);
    }

    @Test
    public void testExtraHeaders() {
        Metadata emptyHeaders = new Metadata();
        HashMap<String, ImmutableList> extraHeaders = new HashMap<String, ImmutableList>();
        extraHeaders.put("header-key-1", ImmutableList.of((Object)"header-value-11", (Object)"header-value-12"));
        extraHeaders.put("header-key-2", ImmutableList.of((Object)"header-value-21"));
        MethodDescriptor<Color, Money> descriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        ClientCall mockClientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ClientCall.Listener mockListener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        Channel mockChannel = (Channel)Mockito.mock(ManagedChannel.class);
        ((ClientCall)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                Metadata clientCallHeaders = (Metadata)invocation.getArguments()[1];
                Metadata.Key key1 = Metadata.Key.of((String)"header-key-1", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                Metadata.Key key2 = Metadata.Key.of((String)"header-key-2", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                Truth.assertThat((Iterable)clientCallHeaders.getAll(key1)).containsExactly(new Object[]{"header-value-11", "header-value-12"});
                Truth.assertThat((Iterable)clientCallHeaders.getAll(key2)).containsExactly(new Object[]{"header-value-21"});
                return null;
            }
        }).when((Object)mockClientCall)).start((ClientCall.Listener)Mockito.any(), (Metadata)Mockito.any());
        Mockito.when((Object)mockChannel.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)Mockito.any())).thenReturn((Object)mockClientCall);
        GrpcCallContext context = GrpcCallContext.createDefault().withChannel(mockChannel).withExtraHeaders(extraHeaders);
        GrpcClientCalls.newCall(descriptor, (ApiCallContext)context).start(mockListener, emptyHeaders);
    }

    @Test
    public void testTimeoutToDeadlineConversion() {
        MethodDescriptor<Color, Money> descriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        ClientCall mockClientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ClientCall.Listener mockListener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        Channel mockChannel = (Channel)Mockito.mock(ManagedChannel.class);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(CallOptions.class);
        Mockito.when((Object)mockChannel.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)capturedCallOptions.capture())).thenReturn((Object)mockClientCall);
        Duration timeout = Duration.ofSeconds((long)10L);
        Deadline minExpectedDeadline = Deadline.after((long)timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
        GrpcCallContext context = GrpcCallContext.createDefault().withChannel(mockChannel).withTimeout(timeout);
        GrpcClientCalls.newCall(descriptor, (ApiCallContext)context).start(mockListener, new Metadata());
        Deadline maxExpectedDeadline = Deadline.after((long)timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
        Truth.assertThat((Comparable)((CallOptions)capturedCallOptions.getValue()).getDeadline()).isAtLeast((Comparable)minExpectedDeadline);
        Truth.assertThat((Comparable)((CallOptions)capturedCallOptions.getValue()).getDeadline()).isAtMost((Comparable)maxExpectedDeadline);
    }

    @Test
    public void testTimeoutAfterDeadline() {
        MethodDescriptor<Color, Money> descriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        ClientCall mockClientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ClientCall.Listener mockListener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        Channel mockChannel = (Channel)Mockito.mock(ManagedChannel.class);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(CallOptions.class);
        Mockito.when((Object)mockChannel.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)capturedCallOptions.capture())).thenReturn((Object)mockClientCall);
        Deadline priorDeadline = Deadline.after((long)5L, (TimeUnit)TimeUnit.SECONDS);
        Duration timeout = Duration.ofSeconds((long)10L);
        GrpcCallContext context = GrpcCallContext.createDefault().withChannel(mockChannel).withCallOptions(CallOptions.DEFAULT.withDeadline(priorDeadline)).withTimeout(timeout);
        GrpcClientCalls.newCall(descriptor, (ApiCallContext)context).start(mockListener, new Metadata());
        Truth.assertThat((Comparable)((CallOptions)capturedCallOptions.getValue()).getDeadline()).isEqualTo((Object)priorDeadline);
    }

    @Test
    public void testTimeoutBeforeDeadline() {
        MethodDescriptor<Color, Money> descriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        ClientCall mockClientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ClientCall.Listener mockListener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        Channel mockChannel = (Channel)Mockito.mock(ManagedChannel.class);
        ArgumentCaptor capturedCallOptions = ArgumentCaptor.forClass(CallOptions.class);
        Mockito.when((Object)mockChannel.newCall((MethodDescriptor)Mockito.eq(descriptor), (CallOptions)capturedCallOptions.capture())).thenReturn((Object)mockClientCall);
        Duration timeout = Duration.ofSeconds((long)5L);
        Deadline subsequentDeadline = Deadline.after((long)10L, (TimeUnit)TimeUnit.SECONDS);
        Deadline minExpectedDeadline = Deadline.after((long)timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
        GrpcCallContext context = GrpcCallContext.createDefault().withChannel(mockChannel).withCallOptions(CallOptions.DEFAULT.withDeadline(subsequentDeadline)).withTimeout(timeout);
        GrpcClientCalls.newCall(descriptor, (ApiCallContext)context).start(mockListener, new Metadata());
        Deadline maxExpectedDeadline = Deadline.after((long)timeout.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
        Truth.assertThat((Comparable)((CallOptions)capturedCallOptions.getValue()).getDeadline()).isAtLeast((Comparable)minExpectedDeadline);
        Truth.assertThat((Comparable)((CallOptions)capturedCallOptions.getValue()).getDeadline()).isAtMost((Comparable)maxExpectedDeadline);
    }
}

