/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class TimeoutTest {
    private static final String CALL_OPTIONS_AUTHORITY = "RETRYING_TEST";
    private static final int DEADLINE_IN_DAYS = 7;
    private static final int DEADLINE_IN_MINUTES = 10;
    private static final int DEADLINE_IN_SECONDS = 20;
    private static final ImmutableSet<StatusCode.Code> emptyRetryCodes = ImmutableSet.of();
    private static final Duration totalTimeout = Duration.ofDays((long)7L);
    private static final Duration maxRpcTimeout = Duration.ofMinutes((long)10L);
    private static final Duration initialRpcTimeout = Duration.ofSeconds((long)20L);
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule().strictness(Strictness.STRICT_STUBS);
    @Mock
    private MethodDescriptor.Marshaller<String> stringMarshaller;
    @Mock
    private RequestParamsExtractor<String> paramsExtractor;
    @Mock
    private ManagedChannel managedChannel;

    @Test
    public void testNonRetryUnarySettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setInitialRpcTimeout(initialRpcTimeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(maxRpcTimeout).build();
        CallOptions callOptionsUsed = this.setupUnaryCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)19L, (TimeUnit)TimeUnit.SECONDS));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    @Test
    public void testNonRetryUnarySettingsWithoutInitialRpcTimeout() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(maxRpcTimeout).build();
        CallOptions callOptionsUsed = this.setupUnaryCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)9L, (TimeUnit)TimeUnit.MINUTES));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)10L, (TimeUnit)TimeUnit.MINUTES));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    @Test
    public void testNonRetryUnarySettingsWithoutIndividualRpcTimeout() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setRpcTimeoutMultiplier(1.0).setRpcTimeoutMultiplier(1.0).build();
        CallOptions callOptionsUsed = this.setupUnaryCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)6L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)7L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    @Test
    public void testNonRetryServerStreamingSettings() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setInitialRpcTimeout(initialRpcTimeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(maxRpcTimeout).build();
        CallOptions callOptionsUsed = this.setupServerStreamingCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)19L, (TimeUnit)TimeUnit.SECONDS));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    @Test
    public void testNonRetryServerStreamingSettingsWithoutInitialRpcTimeout() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(maxRpcTimeout).build();
        CallOptions callOptionsUsed = this.setupServerStreamingCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)9L, (TimeUnit)TimeUnit.MINUTES));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)10L, (TimeUnit)TimeUnit.MINUTES));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    @Test
    public void testNonRetryServerStreamingSettingsWithoutIndividualRpcTimeout() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setTotalTimeout(totalTimeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setMaxAttempts(1).setJittered(true).setRpcTimeoutMultiplier(1.0).setRpcTimeoutMultiplier(1.0).build();
        CallOptions callOptionsUsed = this.setupServerStreamingCallable(retrySettings);
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isNotNull();
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isGreaterThan((Comparable)Deadline.after((long)6L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((Comparable)callOptionsUsed.getDeadline()).isLessThan((Comparable)Deadline.after((long)7L, (TimeUnit)TimeUnit.DAYS));
        Truth.assertThat((String)callOptionsUsed.getAuthority()).isEqualTo((Object)CALL_OPTIONS_AUTHORITY);
    }

    private CallOptions setupUnaryCallable(RetrySettings retrySettings) {
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setSchemaDescriptor((Object)"yaml").setFullMethodName("fake.test/RingRing").setResponseMarshaller(this.stringMarshaller).setRequestMarshaller(this.stringMarshaller).setType(MethodDescriptor.MethodType.UNARY).build();
        ClientCall clientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ((ManagedChannel)Mockito.doReturn((Object)clientCall).when((Object)this.managedChannel)).newCall((MethodDescriptor)ArgumentMatchers.eq((Object)methodDescriptor), (CallOptions)ArgumentMatchers.any(CallOptions.class));
        CallOptions spyCallOptions = CallOptions.DEFAULT.withAuthority(CALL_OPTIONS_AUTHORITY);
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault().withChannel((Channel)this.managedChannel).withCallOptions(spyCallOptions);
        ArgumentCaptor callOptionsArgumentCaptor = ArgumentCaptor.forClass(CallOptions.class);
        ((ClientCall)Mockito.doThrow((Throwable[])new Throwable[]{new ApiException((Throwable)new RuntimeException(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.UNAVAILABLE), false)}).when((Object)clientCall)).halfClose();
        GrpcCallSettings grpcCallSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(methodDescriptor).setParamsExtractor(this.paramsExtractor).build();
        UnaryCallSettings nonRetriedCallSettings = UnaryCallSettings.newUnaryCallSettingsBuilder().setRetrySettings(retrySettings).setRetryableCodes(emptyRetryCodes).build();
        UnaryCallable callable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)grpcCallSettings, (UnaryCallSettings)nonRetriedCallSettings, (ClientContext)ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)grpcCallContext).build());
        try {
            ApiFuture apiFuture = callable.futureCall((Object)"Is your refrigerator running?");
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        ((ManagedChannel)Mockito.verify((Object)this.managedChannel, (VerificationMode)Mockito.times((int)1))).newCall((MethodDescriptor)ArgumentMatchers.eq((Object)methodDescriptor), (CallOptions)callOptionsArgumentCaptor.capture());
        return (CallOptions)callOptionsArgumentCaptor.getValue();
    }

    private CallOptions setupServerStreamingCallable(RetrySettings retrySettings) {
        MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setSchemaDescriptor((Object)"yaml").setFullMethodName("fake.test/RingRing").setResponseMarshaller(this.stringMarshaller).setRequestMarshaller(this.stringMarshaller).setType(MethodDescriptor.MethodType.SERVER_STREAMING).build();
        ClientCall clientCall = (ClientCall)Mockito.mock(ClientCall.class);
        ((ManagedChannel)Mockito.doReturn((Object)clientCall).when((Object)this.managedChannel)).newCall((MethodDescriptor)ArgumentMatchers.eq((Object)methodDescriptor), (CallOptions)ArgumentMatchers.any(CallOptions.class));
        CallOptions spyCallOptions = CallOptions.DEFAULT.withAuthority(CALL_OPTIONS_AUTHORITY);
        GrpcCallContext grpcCallContext = GrpcCallContext.createDefault().withChannel((Channel)this.managedChannel).withCallOptions(spyCallOptions);
        ArgumentCaptor callOptionsArgumentCaptor = ArgumentCaptor.forClass(CallOptions.class);
        ((ClientCall)Mockito.doThrow((Throwable[])new Throwable[]{new ApiException((Throwable)new RuntimeException(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.UNAVAILABLE), false)}).when((Object)clientCall)).halfClose();
        GrpcCallSettings grpcCallSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(methodDescriptor).setParamsExtractor(this.paramsExtractor).build();
        ServerStreamingCallSettings nonRetriedCallSettings = ServerStreamingCallSettings.newBuilder().setRetrySettings(retrySettings).setRetryableCodes(emptyRetryCodes).build();
        ServerStreamingCallable callable = GrpcCallableFactory.createServerStreamingCallable((GrpcCallSettings)grpcCallSettings, (ServerStreamingCallSettings)nonRetriedCallSettings, (ClientContext)ClientContext.newBuilder().setDefaultCallContext((ApiCallContext)grpcCallContext).build());
        try {
            ServerStream serverStream = callable.call((Object)"Is your refrigerator running?");
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        ((ManagedChannel)Mockito.verify((Object)this.managedChannel, (VerificationMode)Mockito.times((int)1))).newCall((MethodDescriptor)ArgumentMatchers.eq((Object)methodDescriptor), (CallOptions)callOptionsArgumentCaptor.capture());
        return (CallOptions)callOptionsArgumentCaptor.getValue();
    }
}

