/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallOptionsUtil;
import com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.api.gax.grpc.ResponseMetadataHandler;
import com.google.api.gax.grpc.testing.FakeMethodDescriptor;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class GrpcMetadataHandlerInterceptorTest {
    @Mock
    private Channel channel;
    @Mock
    private ClientCall<String, Integer> call;
    private static final MethodDescriptor<String, Integer> method = FakeMethodDescriptor.create();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.channel.newCall((MethodDescriptor)Mockito.any(), (CallOptions)ArgumentMatchers.any(CallOptions.class))).thenReturn(this.call);
    }

    @Test
    public void testInterceptor() {
        final MutableBoolean metadataHandlerCalled = new MutableBoolean();
        final MutableBoolean trailingMetadataHandlerCalled = new MutableBoolean();
        CallOptions callOptions = CallOptionsUtil.putMetadataHandlerOption((CallOptions)CallOptions.DEFAULT, (ResponseMetadataHandler)new ResponseMetadataHandler(){

            public void onHeaders(Metadata metadata) {
                metadataHandlerCalled.value = true;
            }

            public void onTrailers(Metadata metadata) {
                trailingMetadataHandlerCalled.value = true;
            }
        });
        GrpcMetadataHandlerInterceptor interceptor = new GrpcMetadataHandlerInterceptor();
        Channel intercepted = ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        ClientCall interceptedCall = intercepted.newCall(method, callOptions);
        Assert.assertFalse((boolean)metadataHandlerCalled.value);
        Assert.assertFalse((boolean)trailingMetadataHandlerCalled.value);
        interceptedCall.start(listener, new Metadata());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ClientCall.Listener.class);
        ArgumentCaptor metadataCaptor = ArgumentCaptor.forClass(Metadata.class);
        ((ClientCall)Mockito.verify(this.call)).start((ClientCall.Listener)captor.capture(), (Metadata)metadataCaptor.capture());
        Assert.assertFalse((boolean)metadataHandlerCalled.value);
        Assert.assertFalse((boolean)trailingMetadataHandlerCalled.value);
        ((ClientCall.Listener)captor.getValue()).onHeaders(new Metadata());
        Assert.assertTrue((boolean)metadataHandlerCalled.value);
        Assert.assertFalse((boolean)trailingMetadataHandlerCalled.value);
        ((ClientCall.Listener)captor.getValue()).onClose(Status.fromCodeValue((int)0), new Metadata());
        Assert.assertTrue((boolean)metadataHandlerCalled.value);
        Assert.assertTrue((boolean)trailingMetadataHandlerCalled.value);
    }

    private static class MutableBoolean {
        private volatile boolean value = false;

        private MutableBoolean() {
        }
    }
}

