/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.StatusCode;
import com.google.common.truth.Truth;
import io.grpc.Status;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcStatusCodeTest {
    @Test
    public void testGrpcCodeToStatusCode() {
        this.testCodes(StatusCode.Code.OK, Status.Code.OK);
        this.testCodes(StatusCode.Code.CANCELLED, Status.Code.CANCELLED);
        this.testCodes(StatusCode.Code.UNKNOWN, Status.Code.UNKNOWN);
        this.testCodes(StatusCode.Code.INVALID_ARGUMENT, Status.Code.INVALID_ARGUMENT);
        this.testCodes(StatusCode.Code.DEADLINE_EXCEEDED, Status.Code.DEADLINE_EXCEEDED);
        this.testCodes(StatusCode.Code.NOT_FOUND, Status.Code.NOT_FOUND);
        this.testCodes(StatusCode.Code.ALREADY_EXISTS, Status.Code.ALREADY_EXISTS);
        this.testCodes(StatusCode.Code.PERMISSION_DENIED, Status.Code.PERMISSION_DENIED);
        this.testCodes(StatusCode.Code.RESOURCE_EXHAUSTED, Status.Code.RESOURCE_EXHAUSTED);
        this.testCodes(StatusCode.Code.FAILED_PRECONDITION, Status.Code.FAILED_PRECONDITION);
        this.testCodes(StatusCode.Code.ABORTED, Status.Code.ABORTED);
        this.testCodes(StatusCode.Code.OUT_OF_RANGE, Status.Code.OUT_OF_RANGE);
        this.testCodes(StatusCode.Code.UNIMPLEMENTED, Status.Code.UNIMPLEMENTED);
        this.testCodes(StatusCode.Code.INTERNAL, Status.Code.INTERNAL);
        this.testCodes(StatusCode.Code.UNAVAILABLE, Status.Code.UNAVAILABLE);
        this.testCodes(StatusCode.Code.DATA_LOSS, Status.Code.DATA_LOSS);
        this.testCodes(StatusCode.Code.UNAUTHENTICATED, Status.Code.UNAUTHENTICATED);
    }

    private void testCodes(StatusCode.Code gaxCode, Status.Code grpcCode) {
        Truth.assertThat((Comparable)GrpcStatusCode.grpcCodeToStatusCode((Status.Code)grpcCode)).isEqualTo((Object)gaxCode);
    }
}

