/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ChannelPool;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class ChannelPoolTest {
    @Test
    public void testAuthority() {
        ManagedChannel sub1 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        ManagedChannel sub2 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        Mockito.when((Object)sub1.authority()).thenReturn((Object)"myAuth");
        ChannelPool pool = new ChannelPool((List)Lists.newArrayList((Object[])new ManagedChannel[]{sub1, sub2}));
        Truth.assertThat((String)pool.authority()).isEqualTo((Object)"myAuth");
    }

    @Test
    public void testRoundRobin() {
        ManagedChannel sub1 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        ManagedChannel sub2 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        Mockito.when((Object)sub1.authority()).thenReturn((Object)"myAuth");
        ArrayList channels = Lists.newArrayList((Object[])new ManagedChannel[]{sub1, sub2});
        ChannelPool pool = new ChannelPool((List)channels);
        this.verifyTargetChannel(pool, channels, sub1);
        this.verifyTargetChannel(pool, channels, sub2);
        this.verifyTargetChannel(pool, channels, sub1);
    }

    private void verifyTargetChannel(ChannelPool pool, List<ManagedChannel> channels, ManagedChannel targetChannel) {
        MethodDescriptor<Color, Money> methodDescriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        CallOptions callOptions = CallOptions.DEFAULT;
        ClientCall expectedClientCall = (ClientCall)Mockito.mock(ClientCall.class);
        for (ManagedChannel channel : channels) {
            Mockito.reset((Object[])new ManagedChannel[]{channel});
        }
        ((ManagedChannel)Mockito.doReturn((Object)expectedClientCall).when((Object)targetChannel)).newCall(methodDescriptor, callOptions);
        ClientCall actualCall = pool.newCall(methodDescriptor, callOptions);
        Truth.assertThat((Object)actualCall).isSameInstanceAs((Object)expectedClientCall);
        ((ManagedChannel)Mockito.verify((Object)targetChannel, (VerificationMode)Mockito.times((int)1))).newCall(methodDescriptor, callOptions);
        for (ManagedChannel otherChannel : channels) {
            if (otherChannel == targetChannel) continue;
            ((ManagedChannel)Mockito.verify((Object)otherChannel, (VerificationMode)Mockito.never())).newCall(methodDescriptor, callOptions);
        }
    }

    @Test
    public void ensureEvenDistribution() throws InterruptedException {
        int numChannels = 10;
        ManagedChannel[] channels = new ManagedChannel[numChannels];
        final AtomicInteger[] counts = new AtomicInteger[numChannels];
        final MethodDescriptor<Color, Money> methodDescriptor = FakeServiceGrpc.METHOD_RECOGNIZE;
        final CallOptions callOptions = CallOptions.DEFAULT;
        final ClientCall clientCall = (ClientCall)Mockito.mock(ClientCall.class);
        for (int i = 0; i < numChannels; ++i) {
            final int index = i;
            counts[i] = new AtomicInteger();
            channels[i] = (ManagedChannel)Mockito.mock(ManagedChannel.class);
            Mockito.when((Object)channels[i].newCall(methodDescriptor, callOptions)).thenAnswer((Answer)new Answer<ClientCall<Color, Money>>(){

                public ClientCall<Color, Money> answer(InvocationOnMock invocationOnMock) throws Throwable {
                    counts[index].incrementAndGet();
                    return clientCall;
                }
            });
        }
        final ChannelPool pool = new ChannelPool(Arrays.asList(channels));
        int numThreads = 20;
        int numPerThread = 1000;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    for (int j = 0; j < 1000; ++j) {
                        pool.newCall(methodDescriptor, callOptions);
                    }
                }
            });
        }
        executor.shutdown();
        boolean shutdown = executor.awaitTermination(1L, TimeUnit.MINUTES);
        Truth.assertThat((Boolean)shutdown).isTrue();
        int expectedCount = numThreads * 1000 / numChannels;
        for (AtomicInteger count : counts) {
            Truth.assertThat((Integer)count.get()).isAnyOf((Object)expectedCount, (Object)(expectedCount + 1), new Object[0]);
        }
    }
}

