/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcOperationSnapshot;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.UnavailableException;
import com.google.common.truth.Truth;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.Status;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoOperationTransformersTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testResponseTransformer() {
        ProtoOperationTransformers.ResponseTransformer transformer = ProtoOperationTransformers.ResponseTransformer.create(Money.class);
        Money inputMoney = Money.newBuilder().setCurrencyCode("USD").build();
        GrpcOperationSnapshot operationSnapshot = GrpcOperationSnapshot.create((Operation)Operation.newBuilder().setResponse(Any.pack((Message)inputMoney)).build());
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)inputMoney);
    }

    @Test
    public void testResponseTransformer_exception() {
        this.thrown.expect(UnavailableException.class);
        ProtoOperationTransformers.ResponseTransformer transformer = ProtoOperationTransformers.ResponseTransformer.create(Money.class);
        Money inputMoney = Money.newBuilder().setCurrencyCode("USD").build();
        Status status = Status.newBuilder().setCode(Status.Code.UNAVAILABLE.value()).build();
        GrpcOperationSnapshot operationSnapshot = GrpcOperationSnapshot.create((Operation)Operation.newBuilder().setResponse(Any.pack((Message)inputMoney)).setError(status).build());
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)inputMoney);
    }

    @Test
    public void testResponseTransformer_mismatchedTypes() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("Failed to unpack object");
        ProtoOperationTransformers.ResponseTransformer transformer = ProtoOperationTransformers.ResponseTransformer.create(Money.class);
        Money inputMoney = Money.newBuilder().setCurrencyCode("USD").build();
        Status status = Status.newBuilder().setCode(Status.Code.OK.value()).build();
        GrpcOperationSnapshot operationSnapshot = GrpcOperationSnapshot.create((Operation)Operation.newBuilder().setResponse(Any.pack((Message)Color.getDefaultInstance())).setError(status).build());
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)inputMoney);
    }

    @Test
    public void testMetadataTransformer() {
        ProtoOperationTransformers.MetadataTransformer transformer = ProtoOperationTransformers.MetadataTransformer.create(Money.class);
        Money inputMoney = Money.newBuilder().setCurrencyCode("USD").build();
        GrpcOperationSnapshot operationSnapshot = GrpcOperationSnapshot.create((Operation)Operation.newBuilder().setMetadata(Any.pack((Message)inputMoney)).build());
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)inputMoney);
    }

    @Test
    public void testMetadataTransformer_mismatchedTypes() {
        this.thrown.expect(ApiException.class);
        this.thrown.expectMessage("Failed to unpack object");
        ProtoOperationTransformers.MetadataTransformer transformer = ProtoOperationTransformers.MetadataTransformer.create(Money.class);
        Money inputMoney = Money.newBuilder().setCurrencyCode("USD").build();
        Status status = Status.newBuilder().setCode(Status.Code.OK.value()).build();
        GrpcOperationSnapshot operationSnapshot = GrpcOperationSnapshot.create((Operation)Operation.newBuilder().setMetadata(Any.pack((Message)Color.getDefaultInstance())).setError(status).build());
        Truth.assertThat((Object)transformer.apply((OperationSnapshot)operationSnapshot)).isEqualTo((Object)inputMoney);
    }
}

