/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.testing.FakeServiceGrpc;
import com.google.api.gax.grpc.testing.FakeServiceImpl;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.type.Color;
import com.google.type.Money;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GrpcDirectServerStreamingCallableTest {
    private static final Color DEFAULT_REQUEST = Color.newBuilder().setRed(0.5f).build();
    private static final Color ASYNC_REQUEST = DEFAULT_REQUEST.toBuilder().setGreen(1000.0f).build();
    private static final Color ERROR_REQUEST = Color.newBuilder().setRed(-1.0f).build();
    private static final Money DEFAULT_RESPONSE = Money.newBuilder().setCurrencyCode("USD").setUnits(127L).build();
    private InProcessServer<FakeServiceImpl> inprocessServer;
    private ManagedChannel channel;
    private ClientContext clientContext;
    private ServerStreamingCallSettings<Color, Money> streamingCallSettings;
    private ServerStreamingCallable<Color, Money> streamingCallable;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws InstantiationException, IllegalAccessException, IOException {
        String serverName = "fakeservice";
        FakeServiceImpl serviceImpl = new FakeServiceImpl();
        this.inprocessServer = new InProcessServer<FakeServiceImpl>(serviceImpl, serverName);
        this.inprocessServer.start();
        this.channel = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).usePlaintext().build();
        this.clientContext = ClientContext.newBuilder().setTransportChannel((TransportChannel)GrpcTransportChannel.create((ManagedChannel)this.channel)).setDefaultCallContext((ApiCallContext)GrpcCallContext.of((Channel)this.channel, (CallOptions)CallOptions.DEFAULT)).build();
        this.streamingCallSettings = ServerStreamingCallSettings.newBuilder().build();
        this.streamingCallable = GrpcCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_SERVER_STREAMING_RECOGNIZE), this.streamingCallSettings, (ClientContext)this.clientContext);
    }

    @After
    public void tearDown() {
        this.channel.shutdown();
        this.inprocessServer.stop();
    }

    @Test
    public void testBadContext() {
        this.streamingCallable = GrpcCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.create(FakeServiceGrpc.METHOD_SERVER_STREAMING_RECOGNIZE), this.streamingCallSettings, (ClientContext)this.clientContext.toBuilder().setDefaultCallContext((ApiCallContext)FakeCallContext.createDefault()).build());
        CountDownLatch latch = new CountDownLatch(1);
        MoneyObserver observer = new MoneyObserver(true, latch);
        this.thrown.expect(IllegalArgumentException.class);
        this.streamingCallable.call((Object)DEFAULT_REQUEST, (ResponseObserver)observer);
    }

    @Test
    public void testServerStreamingStart() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        MoneyObserver moneyObserver = new MoneyObserver(true, latch);
        this.streamingCallable.call((Object)DEFAULT_REQUEST, (ResponseObserver)moneyObserver);
        Truth.assertThat((Object)moneyObserver.controller).isNotNull();
    }

    @Test
    public void testServerStreaming() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        MoneyObserver moneyObserver = new MoneyObserver(true, latch);
        this.streamingCallable.call((Object)DEFAULT_REQUEST, (ResponseObserver)moneyObserver);
        latch.await(20L, TimeUnit.SECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isNull();
        Truth.assertThat((Object)moneyObserver.response).isEqualTo((Object)DEFAULT_RESPONSE);
    }

    @Test
    public void testManualFlowControl() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        MoneyObserver moneyObserver = new MoneyObserver(false, latch);
        this.streamingCallable.call((Object)DEFAULT_REQUEST, (ResponseObserver)moneyObserver);
        latch.await(500L, TimeUnit.MILLISECONDS);
        Truth.assertWithMessage((String)"Received response before requesting it").that((Object)moneyObserver.response).isNull();
        moneyObserver.controller.request(1);
        latch.await(500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Object)moneyObserver.response).isEqualTo((Object)DEFAULT_RESPONSE);
        Truth.assertThat((Boolean)moneyObserver.completed).isTrue();
    }

    @Test
    public void testCancelClientCall() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        MoneyObserver moneyObserver = new MoneyObserver(false, latch);
        this.streamingCallable.call((Object)ASYNC_REQUEST, (ResponseObserver)moneyObserver);
        moneyObserver.controller.cancel();
        moneyObserver.controller.request(1);
        latch.await(500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isInstanceOf(CancellationException.class);
        Truth.assertThat((Throwable)moneyObserver.error).hasMessageThat().isEqualTo((Object)"User cancelled stream");
    }

    @Test
    public void testOnResponseError() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        MoneyObserver moneyObserver = new MoneyObserver(true, latch);
        this.streamingCallable.call((Object)ERROR_REQUEST, (ResponseObserver)moneyObserver);
        latch.await(500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Throwable)moneyObserver.error).isInstanceOf(ApiException.class);
        Truth.assertThat((Comparable)((ApiException)moneyObserver.error).getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Throwable)moneyObserver.error).hasMessageThat().isEqualTo((Object)"io.grpc.StatusRuntimeException: INVALID_ARGUMENT: red must be positive");
    }

    @Test
    public void testObserverErrorCancelsCall() throws Throwable {
        final RuntimeException expectedCause = new RuntimeException("some error");
        final SettableApiFuture actualErrorF = SettableApiFuture.create();
        StateCheckingResponseObserver<Money> moneyObserver = new StateCheckingResponseObserver<Money>(){

            protected void onStartImpl(StreamController controller) {
            }

            protected void onResponseImpl(Money response) {
                throw expectedCause;
            }

            protected void onErrorImpl(Throwable t) {
                actualErrorF.set((Object)t);
            }

            protected void onCompleteImpl() {
                actualErrorF.set(null);
            }
        };
        this.streamingCallable.call((Object)DEFAULT_REQUEST, (ResponseObserver)moneyObserver);
        Throwable actualError = (Throwable)actualErrorF.get(500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Throwable)actualError).isInstanceOf(ApiException.class);
        Truth.assertThat((Comparable)((ApiException)actualError).getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.CANCELLED);
        Truth.assertThat((Throwable)actualError.getCause()).isInstanceOf(StatusRuntimeException.class);
        Truth.assertThat((Throwable)actualError.getCause().getCause()).isSameInstanceAs((Object)expectedCause);
    }

    @Test
    public void testBlockingServerStreaming() throws Exception {
        Color request = Color.newBuilder().setRed(0.5f).build();
        ServerStream response = this.streamingCallable.call((Object)request);
        ArrayList responseData = Lists.newArrayList((Iterable)response);
        Money expected = Money.newBuilder().setCurrencyCode("USD").setUnits(127L).build();
        Truth.assertThat((Iterable)responseData).containsExactly(new Object[]{expected});
    }

    static class MoneyObserver
    extends StateCheckingResponseObserver<Money> {
        private final boolean autoFlowControl;
        private final CountDownLatch latch;
        volatile StreamController controller;
        volatile Money response;
        volatile Throwable error;
        volatile boolean completed;

        MoneyObserver(boolean autoFlowControl, CountDownLatch latch) {
            this.autoFlowControl = autoFlowControl;
            this.latch = latch;
        }

        protected void onStartImpl(StreamController controller) {
            this.controller = controller;
            if (!this.autoFlowControl) {
                controller.disableAutoInboundFlowControl();
            }
        }

        protected void onResponseImpl(Money value) {
            this.response = value;
            this.latch.countDown();
        }

        protected void onErrorImpl(Throwable t) {
            this.error = t;
            this.latch.countDown();
        }

        protected void onCompleteImpl() {
            this.completed = true;
            this.latch.countDown();
        }
    }
}

