/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ChannelFactory;
import com.google.api.gax.grpc.MockClientCall;
import com.google.api.gax.grpc.RefreshingManagedChannel;
import com.google.api.gax.grpc.testing.FakeChannelFactory;
import com.google.api.gax.grpc.testing.FakeMethodDescriptor;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class RefreshingManagedChannelTest {
    @Test
    public void channelRefreshShouldSwapChannels() throws IOException {
        ManagedChannel underlyingChannel1 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        ManagedChannel underlyingChannel2 = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        final ArrayList channelRefreshers = new ArrayList();
        Answer extractChannelRefresher = new Answer(){

            public Object answer(InvocationOnMock invocation) {
                channelRefreshers.add((Runnable)invocation.getArgument(0));
                return null;
            }
        };
        ((ScheduledExecutorService)Mockito.doAnswer((Answer)extractChannelRefresher).when((Object)scheduledExecutorService)).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        FakeChannelFactory channelFactory = new FakeChannelFactory(Arrays.asList(underlyingChannel1, underlyingChannel2));
        RefreshingManagedChannel refreshingManagedChannel = new RefreshingManagedChannel((ChannelFactory)channelFactory, scheduledExecutorService);
        refreshingManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel1, (VerificationMode)Mockito.only())).newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class));
        ((Runnable)channelRefreshers.get(0)).run();
        refreshingManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel2, (VerificationMode)Mockito.only())).newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class));
    }

    @Test
    public void randomizeTest() throws IOException, InterruptedException, ExecutionException {
        int channelCount = 10;
        ManagedChannel[] underlyingChannels = new ManagedChannel[channelCount];
        final Random r = new Random();
        for (int i = 0; i < channelCount; ++i) {
            ManagedChannel mockManagedChannel;
            underlyingChannels[i] = mockManagedChannel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
            final Answer waitAndSendMessage = new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    TimeUnit.MICROSECONDS.sleep(r.nextInt(1000));
                    ((ManagedChannel)Mockito.verify((Object)mockManagedChannel, (VerificationMode)Mockito.never())).shutdown();
                    return invocation.callRealMethod();
                }
            };
            Answer createNewCall = new Answer(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    MockClientCall mockClientCall = new MockClientCall(1, Status.OK);
                    MockClientCall spyClientCall = (MockClientCall)((Object)Mockito.spy(mockClientCall));
                    ((MockClientCall)((Object)Mockito.doAnswer((Answer)waitAndSendMessage).when((Object)spyClientCall))).sendMessage(Mockito.anyString());
                    return spyClientCall;
                }
            };
            ((ManagedChannel)Mockito.doAnswer((Answer)createNewCall).when((Object)underlyingChannels[i])).newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class));
        }
        final ArrayList channelRefreshers = new ArrayList();
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Answer extractChannelRefresher = new Answer(){

            public Object answer(InvocationOnMock invocation) {
                channelRefreshers.add((Runnable)invocation.getArgument(0));
                return null;
            }
        };
        ((ScheduledExecutorService)Mockito.doAnswer((Answer)extractChannelRefresher).when((Object)scheduledExecutorService)).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        FakeChannelFactory channelFactory = new FakeChannelFactory(Arrays.asList(underlyingChannels));
        RefreshingManagedChannel refreshingManagedChannel = new RefreshingManagedChannel((ChannelFactory)channelFactory, scheduledExecutorService);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < channelCount - 1; ++i) {
            ArrayList futures = new ArrayList();
            int requestCount = 100;
            int whenToRefresh = r.nextInt(requestCount);
            for (int j = 0; j < requestCount; ++j) {
                Runnable runnable = new Runnable((ManagedChannel)refreshingManagedChannel){
                    final /* synthetic */ ManagedChannel val$refreshingManagedChannel;
                    {
                        this.val$refreshingManagedChannel = managedChannel;
                    }

                    @Override
                    public void run() {
                        ClientCall call = this.val$refreshingManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
                        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
                        call.start(listener, new Metadata());
                        call.sendMessage((Object)"message");
                    }
                };
                futures.add(executor.submit(runnable));
                if (j != whenToRefresh) continue;
                futures.add(executor.submit((Runnable)channelRefreshers.get(i)));
            }
            for (Future future : futures) {
                future.get();
            }
            ((ManagedChannel)Mockito.verify((Object)underlyingChannels[i], (VerificationMode)Mockito.atLeastOnce())).shutdown();
            ((ManagedChannel)Mockito.verify((Object)underlyingChannels[i + 1], (VerificationMode)Mockito.never())).shutdown();
        }
    }
}

