/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.MockClientCall;
import com.google.api.gax.grpc.SafeShutdownManagedChannel;
import com.google.api.gax.grpc.testing.FakeMethodDescriptor;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SafeShutdownManagedChannelTest {
    @Test
    public void callShouldCompleteAfterCreation() {
        final ManagedChannel underlyingChannel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        SafeShutdownManagedChannel safeShutdownManagedChannel = new SafeShutdownManagedChannel(underlyingChannel);
        MockClientCall mockClientCall = new MockClientCall(1, Status.OK);
        MockClientCall spyClientCall = (MockClientCall)((Object)Mockito.spy(mockClientCall));
        Mockito.when((Object)underlyingChannel.newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class))).thenReturn((Object)spyClientCall);
        Answer verifyChannelNotShutdown = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.never())).shutdown();
                return invocation.callRealMethod();
            }
        };
        ((MockClientCall)((Object)Mockito.doAnswer((Answer)verifyChannelNotShutdown).when((Object)spyClientCall))).sendMessage(Mockito.anyString());
        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        ClientCall call = safeShutdownManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
        safeShutdownManagedChannel.shutdownSafely();
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.after((long)200L).never())).shutdown();
        call.start(listener, new Metadata());
        call.sendMessage((Object)"message");
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.atLeastOnce())).shutdown();
    }

    @Test
    public void callShouldCompleteAfterStarted() {
        final ManagedChannel underlyingChannel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        SafeShutdownManagedChannel safeShutdownManagedChannel = new SafeShutdownManagedChannel(underlyingChannel);
        MockClientCall mockClientCall = new MockClientCall(1, Status.OK);
        MockClientCall spyClientCall = (MockClientCall)((Object)Mockito.spy(mockClientCall));
        Mockito.when((Object)underlyingChannel.newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class))).thenReturn((Object)spyClientCall);
        Answer verifyChannelNotShutdown = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.never())).shutdown();
                return invocation.callRealMethod();
            }
        };
        ((MockClientCall)((Object)Mockito.doAnswer((Answer)verifyChannelNotShutdown).when((Object)spyClientCall))).sendMessage(Mockito.anyString());
        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        ClientCall call = safeShutdownManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
        call.start(listener, new Metadata());
        safeShutdownManagedChannel.shutdownSafely();
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.after((long)200L).never())).shutdown();
        call.sendMessage((Object)"message");
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.atLeastOnce())).shutdown();
    }

    @Test
    public void channelShouldShutdown() {
        final ManagedChannel underlyingChannel = (ManagedChannel)Mockito.mock(ManagedChannel.class);
        SafeShutdownManagedChannel safeShutdownManagedChannel = new SafeShutdownManagedChannel(underlyingChannel);
        MockClientCall mockClientCall = new MockClientCall(1, Status.OK);
        MockClientCall spyClientCall = (MockClientCall)((Object)Mockito.spy(mockClientCall));
        Mockito.when((Object)underlyingChannel.newCall((MethodDescriptor)Mockito.any(), (CallOptions)Mockito.any(CallOptions.class))).thenReturn((Object)spyClientCall);
        Answer verifyChannelNotShutdown = new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.never())).shutdown();
                return invocation.callRealMethod();
            }
        };
        ((MockClientCall)((Object)Mockito.doAnswer((Answer)verifyChannelNotShutdown).when((Object)spyClientCall))).sendMessage(Mockito.anyString());
        ClientCall.Listener listener = (ClientCall.Listener)Mockito.mock(ClientCall.Listener.class);
        ClientCall call = safeShutdownManagedChannel.newCall(FakeMethodDescriptor.create(), CallOptions.DEFAULT);
        call.start(listener, new Metadata());
        call.sendMessage((Object)"message");
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.after((long)200L).never())).shutdown();
        safeShutdownManagedChannel.shutdownSafely();
        ((ManagedChannel)Mockito.verify((Object)underlyingChannel, (VerificationMode)Mockito.atLeastOnce())).shutdown();
    }
}

