/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson.testing;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public final class MockHttpService
extends MockHttpTransport {
    private final Multimap<String, String> requestHeaders = LinkedListMultimap.create();
    private final List<String> requestPaths = new LinkedList<String>();
    private final Queue<HttpResponseFactory> responseHandlers = new LinkedList<HttpResponseFactory>();
    private final List<ApiMethodDescriptor> serviceMethodDescriptors;
    private final String endpoint;

    public MockHttpService(List<ApiMethodDescriptor> serviceMethodDescriptors, String pathPrefix) {
        this.serviceMethodDescriptors = ImmutableList.copyOf(serviceMethodDescriptors);
        this.endpoint = pathPrefix;
    }

    public synchronized LowLevelHttpRequest buildRequest(String method, String url) {
        this.requestPaths.add(url);
        return new MockHttpRequest(this, method, url);
    }

    public synchronized void addResponse(Object response) {
        this.responseHandlers.add(new MessageResponseFactory(this.endpoint, this.serviceMethodDescriptors, response));
    }

    public synchronized void addResponse(Object response, Duration delay) {
        this.responseHandlers.add(new MessageResponseFactory(this.endpoint, this.serviceMethodDescriptors, response, delay));
    }

    public synchronized void addNullResponse(int statusCode) {
        this.responseHandlers.add((httpMethod, targetUrl) -> new MockLowLevelHttpResponse().setStatusCode(statusCode));
    }

    public synchronized void addNullResponse() {
        this.addNullResponse(200);
    }

    public synchronized void addException(Exception exception) {
        this.addException(400, exception);
    }

    public synchronized void addException(int statusCode, Exception exception) {
        this.responseHandlers.add(new ExceptionResponseFactory(statusCode, exception));
    }

    public synchronized List<String> getRequestPaths() {
        return this.requestPaths;
    }

    public synchronized Multimap<String, String> getRequestHeaders() {
        return ImmutableListMultimap.copyOf(this.requestHeaders);
    }

    private synchronized void putRequestHeader(String name, String value) {
        this.requestHeaders.put((Object)name, (Object)value);
    }

    private synchronized MockLowLevelHttpResponse getHttpResponse(String method, String url) {
        Preconditions.checkArgument((!this.responseHandlers.isEmpty() ? 1 : 0) != 0);
        return this.responseHandlers.poll().getHttpResponse(method, url);
    }

    public synchronized void reset() {
        this.responseHandlers.clear();
        this.requestPaths.clear();
        this.requestHeaders.clear();
    }

    private static class MessageResponseFactory
    implements HttpResponseFactory {
        private final List<ApiMethodDescriptor> serviceMethodDescriptors;
        private final Object response;
        private final String endpoint;
        private final Duration delay;

        public MessageResponseFactory(String endpoint, List<ApiMethodDescriptor> serviceMethodDescriptors, Object response) {
            this(endpoint, serviceMethodDescriptors, response, Duration.ofNanos(0L));
        }

        public MessageResponseFactory(String endpoint, List<ApiMethodDescriptor> serviceMethodDescriptors, Object response, Duration delay) {
            this.endpoint = endpoint;
            this.serviceMethodDescriptors = ImmutableList.copyOf(serviceMethodDescriptors);
            this.response = response;
            this.delay = delay;
        }

        @Override
        public MockLowLevelHttpResponse getHttpResponse(String httpMethod, String fullTargetUrl) {
            try {
                long delayMs = this.delay.toMillis();
                if (delayMs > 0L) {
                    Thread.sleep(delayMs);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse();
            String relativePath = this.getRelativePath(fullTargetUrl);
            for (ApiMethodDescriptor methodDescriptor : this.serviceMethodDescriptors) {
                String httpContent;
                String descriptorHttpMethod = methodDescriptor.getHttpMethod();
                if (!httpMethod.equals(descriptorHttpMethod) && (!"PATCH".equals(descriptorHttpMethod) || !"POST".equals(httpMethod))) continue;
                PathTemplate pathTemplate = methodDescriptor.getRequestFormatter().getPathTemplate();
                List additionalPathTemplates = methodDescriptor.getRequestFormatter().getAdditionalPathTemplates();
                if (!pathTemplate.matches(relativePath) && additionalPathTemplates.stream().noneMatch(pt -> pt.matches(relativePath))) continue;
                if (methodDescriptor.getType() == ApiMethodDescriptor.MethodType.SERVER_STREAMING) {
                    Object[] responseArray = (Object[])this.response;
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    for (Object responseElement : responseArray) {
                        if (sb.length() > 1) {
                            sb.append(',');
                        }
                        sb.append(methodDescriptor.getResponseParser().serialize(responseElement));
                    }
                    sb.append(']');
                    httpContent = sb.toString();
                } else {
                    httpContent = methodDescriptor.getResponseParser().serialize(this.response);
                }
                httpResponse.setContent(httpContent.getBytes());
                httpResponse.setStatusCode(200);
                return httpResponse;
            }
            httpResponse.setContent(String.format("Method not found for path '%s'", relativePath).getBytes());
            httpResponse.setStatusCode(404);
            return httpResponse;
        }

        private String getRelativePath(String fullTargetUrl) {
            String relativePath = fullTargetUrl.replaceFirst(this.endpoint, "");
            int queryParamIndex = relativePath.indexOf("?");
            queryParamIndex = queryParamIndex < 0 ? relativePath.length() : queryParamIndex;
            relativePath = relativePath.substring(0, queryParamIndex);
            return relativePath;
        }
    }

    private static class ExceptionResponseFactory
    implements HttpResponseFactory {
        private final int statusCode;
        private final Exception exception;

        public ExceptionResponseFactory(int statusCode, Exception exception) {
            this.statusCode = statusCode;
            this.exception = exception;
        }

        @Override
        public MockLowLevelHttpResponse getHttpResponse(String httpMethod, String targetUrl) {
            MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse();
            httpResponse.setStatusCode(this.statusCode);
            httpResponse.setContent(this.exception.toString().getBytes());
            httpResponse.setContentEncoding("text/plain");
            return httpResponse;
        }
    }

    private static class MockHttpRequest
    extends MockLowLevelHttpRequest {
        private final MockHttpService service;
        private final String method;
        private final String url;

        public MockHttpRequest(MockHttpService service, String method, String url) {
            this.service = service;
            this.method = method;
            this.url = url;
        }

        public void addHeader(String name, String value) {
            this.service.putRequestHeader(name, value);
        }

        public LowLevelHttpResponse execute() {
            return this.service.getHttpResponse(this.method, this.url);
        }
    }

    private static interface HttpResponseFactory {
        public MockLowLevelHttpResponse getHttpResponse(String var1, String var2);
    }
}

