/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannel;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.TemporalAmount;

@BetaApi
@InternalExtensionOnly
public final class HttpJsonCallContext
implements ApiCallContext {
    private final HttpJsonChannel channel;
    private final Instant deadline;
    private final Credentials credentials;

    public static HttpJsonCallContext createDefault() {
        return new HttpJsonCallContext(null, null, null);
    }

    private HttpJsonCallContext(HttpJsonChannel channel, Instant deadline, Credentials credentials) {
        this.channel = channel;
        this.deadline = deadline;
        this.credentials = credentials;
    }

    public HttpJsonCallContext nullToSelf(ApiCallContext inputContext) {
        HttpJsonCallContext httpJsonCallContext;
        if (inputContext == null) {
            httpJsonCallContext = this;
        } else {
            if (!(inputContext instanceof HttpJsonCallContext)) {
                throw new IllegalArgumentException("context must be an instance of HttpJsonCallContext, but found " + inputContext.getClass().getName());
            }
            httpJsonCallContext = (HttpJsonCallContext)inputContext;
        }
        return httpJsonCallContext;
    }

    public HttpJsonCallContext merge(ApiCallContext inputCallContext) {
        Credentials newCredentials;
        Instant newDeadline;
        if (inputCallContext == null) {
            return this;
        }
        if (!(inputCallContext instanceof HttpJsonCallContext)) {
            throw new IllegalArgumentException("context must be an instance of GrpcCallContext, but found " + inputCallContext.getClass().getName());
        }
        HttpJsonCallContext httpJsonCallContext = (HttpJsonCallContext)inputCallContext;
        HttpJsonChannel newChannel = httpJsonCallContext.channel;
        if (newChannel == null) {
            newChannel = this.channel;
        }
        if ((newDeadline = httpJsonCallContext.deadline) == null) {
            newDeadline = this.deadline;
        }
        if ((newCredentials = httpJsonCallContext.credentials) == null) {
            newCredentials = this.credentials;
        }
        return new HttpJsonCallContext(newChannel, newDeadline, newCredentials);
    }

    public HttpJsonCallContext withCredentials(Credentials newCredentials) {
        return new HttpJsonCallContext(this.channel, this.deadline, newCredentials);
    }

    public HttpJsonCallContext withTransportChannel(TransportChannel inputChannel) {
        Preconditions.checkNotNull((Object)inputChannel);
        if (!(inputChannel instanceof HttpJsonTransportChannel)) {
            throw new IllegalArgumentException("Expected HttpJsonTransportChannel, got " + inputChannel.getClass().getName());
        }
        HttpJsonTransportChannel transportChannel = (HttpJsonTransportChannel)inputChannel;
        return this.withChannel(transportChannel.getChannel());
    }

    public HttpJsonCallContext withTimeout(Duration rpcTimeout) {
        Instant newDeadline = Instant.now().plus((TemporalAmount)rpcTimeout);
        HttpJsonCallContext nextContext = this.withDeadline(newDeadline);
        if (this.deadline == null) {
            return nextContext;
        }
        if (this.deadline.isBefore(newDeadline)) {
            return this;
        }
        return nextContext;
    }

    public HttpJsonChannel getChannel() {
        return this.channel;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public HttpJsonCallContext withChannel(HttpJsonChannel newChannel) {
        return new HttpJsonCallContext(newChannel, this.deadline, this.credentials);
    }

    public HttpJsonCallContext withDeadline(Instant newDeadline) {
        return new HttpJsonCallContext(this.channel, newDeadline, this.credentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }
}

