/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.AutoValue_ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@BetaApi
public abstract class ApiMethodDescriptor<RequestT, ResponseT> {
    public abstract String getFullMethodName();

    public abstract Gson getBaseGson();

    public abstract Gson getRequestMarshaller();

    @Nullable
    public abstract Gson getResponseMarshaller();

    public abstract Type getRequestType();

    @Nullable
    public abstract Type getResponseType();

    public abstract String getResourceNameField();

    public abstract Set<String> getQueryParams();

    public abstract String getHttpMethod();

    public abstract HttpRequestFormatter<RequestT> getHttpRequestBuilder();

    public abstract String endpointPathTemplate();

    private static <RequestT, ResponseT> ApiMethodDescriptor<RequestT, ResponseT> create(String fullMethodName, RequestT requestInstance, @Nullable ResponseT responseInstance, String endpointPathTemplate, String resourceNameField, Set<String> queryParams, HttpRequestFormatter<RequestT> httpRequestFormatter, String httpMethod) {
        final Class<?> requestType = requestInstance.getClass();
        final Gson baseGson = new GsonBuilder().create();
        TypeAdapter requestTypeAdapter = new TypeAdapter<RequestT>(){

            public void write(JsonWriter out, RequestT value) {
                baseGson.toJson(value, requestType, out);
            }

            public RequestT read(JsonReader in) {
                return null;
            }
        };
        Gson requestMarshaller = new GsonBuilder().registerTypeAdapter(requestType, (Object)requestTypeAdapter).create();
        TypeAdapter responseTypeAdapter = null;
        final Class<?> responseType = responseInstance == null ? null : responseInstance.getClass();
        Gson responseMarshaller = null;
        if (responseInstance != null) {
            responseTypeAdapter = new TypeAdapter<ResponseT>(){

                public void write(JsonWriter out, ResponseT value) {
                    baseGson.toJson(value, responseType, out);
                }

                public ResponseT read(JsonReader in) {
                    return baseGson.fromJson(in, responseType);
                }
            };
            responseMarshaller = new GsonBuilder().registerTypeAdapter(responseType, (Object)responseTypeAdapter).create();
        }
        return new AutoValue_ApiMethodDescriptor(fullMethodName, baseGson, requestMarshaller, responseMarshaller, requestType, responseType, resourceNameField, queryParams, httpMethod, httpRequestFormatter, endpointPathTemplate);
    }

    ResponseT parseResponse(Reader input) {
        return (ResponseT)this.getResponseMarshaller().fromJson(input, this.getResponseType());
    }

    @InternalApi
    public void writeResponse(Appendable output, Class clazz, Object response) {
        this.getResponseMarshaller().toJson(response, (Type)clazz, output);
    }

    void writeRequestBody(RequestT apiMessage, Appendable output) {
        this.getHttpRequestBuilder().writeRequestBody(apiMessage, this.getRequestMarshaller(), output);
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder().setResourceNameField("").setQueryParams(new HashSet<String>()).setHttpMethod("GET");
    }

    public static class Builder<RequestT, ResponseT> {
        String fullMethodName;
        RequestT requestInstance;
        ResponseT responseInstance;
        String endpointPathTemplate;
        String resourceNameField;
        Set<String> queryParams;
        HttpRequestFormatter<RequestT> httpRequestFormatter;
        String httpMethod;

        public Builder<RequestT, ResponseT> setMethodName(String fullMethodName) {
            this.fullMethodName = fullMethodName;
            return this;
        }

        public Builder<RequestT, ResponseT> setRequestInstance(RequestT requestInstance) {
            this.requestInstance = requestInstance;
            return this;
        }

        public Builder<RequestT, ResponseT> setResponseInstance(ResponseT responseInstance) {
            this.responseInstance = responseInstance;
            return this;
        }

        public Builder<RequestT, ResponseT> setEndpointPathTemplate(String endpointPathTemplate) {
            this.endpointPathTemplate = endpointPathTemplate;
            return this;
        }

        public Builder<RequestT, ResponseT> setResourceNameField(String resourceNameField) {
            this.resourceNameField = resourceNameField;
            return this;
        }

        public Builder<RequestT, ResponseT> setQueryParams(Set<String> queryParams) {
            this.queryParams = ImmutableSet.copyOf(queryParams);
            return this;
        }

        public Builder<RequestT, ResponseT> setHttpRequestFormatter(HttpRequestFormatter<RequestT> httpRequestFormatter) {
            this.httpRequestFormatter = httpRequestFormatter;
            return this;
        }

        public Builder<RequestT, ResponseT> setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public ApiMethodDescriptor<RequestT, ResponseT> build() {
            return ApiMethodDescriptor.create(this.fullMethodName, this.requestInstance, this.responseInstance, this.endpointPathTemplate, this.resourceNameField, this.queryParams, this.httpRequestFormatter, this.httpMethod);
        }
    }
}

