/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.tracing.SpanName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class HttpJsonCallableFactoryTest {
    @Test
    public void testGetSpanName() {
        ImmutableMap validNames = ImmutableMap.of((Object)"compute.projects.disableXpnHost", (Object)SpanName.of((String)"compute.projects", (String)"disableXpnHost"), (Object)"client.method", (Object)SpanName.of((String)"client", (String)"method"));
        for (Map.Entry entry : validNames.entrySet()) {
            ApiMethodDescriptor descriptor = ApiMethodDescriptor.newBuilder().setFullMethodName((String)entry.getKey()).setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)Mockito.mock(HttpRequestFormatter.class)).setResponseParser((HttpResponseParser)Mockito.mock(HttpResponseParser.class)).build();
            SpanName actualSpanName = HttpJsonCallableFactory.getSpanName((ApiMethodDescriptor)descriptor);
            Truth.assertThat((Object)actualSpanName).isEqualTo(entry.getValue());
        }
    }

    @Test
    public void testGetSpanNameInvalid() {
        ImmutableList invalidNames = ImmutableList.of((Object)"no_split", (Object)".no_client");
        for (String invalidName : invalidNames) {
            ApiMethodDescriptor descriptor = ApiMethodDescriptor.newBuilder().setFullMethodName(invalidName).setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)Mockito.mock(HttpRequestFormatter.class)).setResponseParser((HttpResponseParser)Mockito.mock(HttpResponseParser.class)).build();
            IllegalArgumentException actualError = null;
            try {
                SpanName spanName = HttpJsonCallableFactory.getSpanName((ApiMethodDescriptor)descriptor);
                Truth.assertWithMessage((String)"Invalid method descriptor should not have a valid span name").fail("%s should not generate the spanName: %s", new Object[]{invalidName, spanName});
            }
            catch (IllegalArgumentException e) {
                actualError = e;
            }
            Truth.assertThat((Throwable)actualError).isNotNull();
        }
    }
}

