/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.httpjson.HttpJsonMetadata;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.ManagedHttpJsonChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.auth.Credentials;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
@InternalExtensionOnly
public final class InstantiatingHttpJsonChannelProvider
implements TransportChannelProvider {
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final String endpoint;
    private final HttpTransport httpTransport;
    private final MtlsProvider mtlsProvider;

    private InstantiatingHttpJsonChannelProvider(Executor executor, HeaderProvider headerProvider, String endpoint) {
        this.executor = executor;
        this.headerProvider = headerProvider;
        this.endpoint = endpoint;
        this.httpTransport = null;
        this.mtlsProvider = new MtlsProvider();
    }

    private InstantiatingHttpJsonChannelProvider(Executor executor, HeaderProvider headerProvider, String endpoint, HttpTransport httpTransport, MtlsProvider mtlsProvider) {
        this.executor = executor;
        this.headerProvider = headerProvider;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport;
        this.mtlsProvider = mtlsProvider;
    }

    @Deprecated
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public boolean acceptsPoolSize() {
        return false;
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public TransportChannelProvider withPoolSize(int size) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't allow pool size customization");
    }

    public String getTransportName() {
        return HttpJsonTransportChannel.getHttpJsonTransportName();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        try {
            return this.createChannel();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public boolean needsCredentials() {
        return false;
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        throw new UnsupportedOperationException("InstantiatingHttpJsonChannelProvider doesn't need credentials");
    }

    HttpTransport createHttpTransport() throws IOException, GeneralSecurityException {
        KeyStore mtlsKeyStore;
        if (this.mtlsProvider.useMtlsClientCertificate() && (mtlsKeyStore = this.mtlsProvider.getKeyStore()) != null) {
            return new NetHttpTransport.Builder().trustCertificates(null, mtlsKeyStore, "").build();
        }
        return null;
    }

    private TransportChannel createChannel() throws IOException, GeneralSecurityException {
        HashMap<String, Object> headers = new HashMap<String, Object>(this.headerProvider.getHeaders());
        HttpTransport httpTransportToUse = this.httpTransport;
        if (httpTransportToUse == null) {
            httpTransportToUse = this.createHttpTransport();
        }
        ManagedHttpJsonChannel channel = ManagedHttpJsonChannel.newBuilder().setEndpoint(this.endpoint).setDefaultHeaders(HttpJsonMetadata.newBuilder().setHeaders(headers).build()).setExecutor(this.executor).setHttpTransport(httpTransportToUse).build();
        return HttpJsonTransportChannel.newBuilder().setManagedChannel(channel).build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Executor executor;
        private HeaderProvider headerProvider;
        private String endpoint;
        private HttpTransport httpTransport;
        private MtlsProvider mtlsProvider = new MtlsProvider();

        private Builder() {
        }

        private Builder(InstantiatingHttpJsonChannelProvider provider) {
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.httpTransport = provider.httpTransport;
            this.mtlsProvider = provider.mtlsProvider;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        @VisibleForTesting
        Builder setMtlsProvider(MtlsProvider mtlsProvider) {
            this.mtlsProvider = mtlsProvider;
            return this;
        }

        public InstantiatingHttpJsonChannelProvider build() {
            return new InstantiatingHttpJsonChannelProvider(this.executor, this.headerProvider, this.endpoint, this.httpTransport, this.mtlsProvider);
        }
    }
}

