
package com.google.api.gax.grpc;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetryParams;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.ManagedChannel;
import io.grpc.Status.Code;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ServiceApiSettings<MethodId> extends ServiceApiSettings<MethodId> {

  private final ImmutableMap<MethodId, ImmutableSet<Code>> retryableCodes;
  private final ImmutableMap<MethodId, RetryParams> retryParams;
  private final ScheduledExecutorService executor;
  private final ServiceApiSettings.ChannelProvider channelProvider;

  private AutoValue_ServiceApiSettings(
      ImmutableMap<MethodId, ImmutableSet<Code>> retryableCodes,
      ImmutableMap<MethodId, RetryParams> retryParams,
      ScheduledExecutorService executor,
      ServiceApiSettings.ChannelProvider channelProvider) {
    if (retryableCodes == null) {
      throw new NullPointerException("Null retryableCodes");
    }
    this.retryableCodes = retryableCodes;
    if (retryParams == null) {
      throw new NullPointerException("Null retryParams");
    }
    this.retryParams = retryParams;
    if (executor == null) {
      throw new NullPointerException("Null executor");
    }
    this.executor = executor;
    if (channelProvider == null) {
      throw new NullPointerException("Null channelProvider");
    }
    this.channelProvider = channelProvider;
  }

  @Override
  public ImmutableMap<MethodId, ImmutableSet<Code>> getRetryableCodes() {
    return retryableCodes;
  }

  @Override
  public ImmutableMap<MethodId, RetryParams> getRetryParams() {
    return retryParams;
  }

  @Override
  public ScheduledExecutorService getExecutor() {
    return executor;
  }

  @Override
  ServiceApiSettings.ChannelProvider getChannelProvider() {
    return channelProvider;
  }

  @Override
  public String toString() {
    return "ServiceApiSettings{"
        + "retryableCodes=" + retryableCodes + ", "
        + "retryParams=" + retryParams + ", "
        + "executor=" + executor + ", "
        + "channelProvider=" + channelProvider
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ServiceApiSettings) {
      ServiceApiSettings<?> that = (ServiceApiSettings<?>) o;
      return (this.retryableCodes.equals(that.getRetryableCodes()))
           && (this.retryParams.equals(that.getRetryParams()))
           && (this.executor.equals(that.getExecutor()))
           && (this.channelProvider.equals(that.getChannelProvider()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= retryableCodes.hashCode();
    h *= 1000003;
    h ^= retryParams.hashCode();
    h *= 1000003;
    h ^= executor.hashCode();
    h *= 1000003;
    h ^= channelProvider.hashCode();
    return h;
  }

  static final class Builder<MethodId> extends ServiceApiSettings.Builder<MethodId> {
    private ImmutableMap<MethodId, ImmutableSet<Code>> retryableCodes;
    private ImmutableMap<MethodId, RetryParams> retryParams;
    private ScheduledExecutorService executor;
    private ServiceApiSettings.ChannelProvider channelProvider;
    Builder() {
    }
    Builder(ServiceApiSettings<MethodId> source) {
      this.retryableCodes = source.getRetryableCodes();
      this.retryParams = source.getRetryParams();
      this.executor = source.getExecutor();
      this.channelProvider = source.getChannelProvider();
    }
    @Override
    public ServiceApiSettings.Builder<MethodId> setRetryableCodes(ImmutableMap<MethodId, ImmutableSet<Code>> retryableCodes) {
      this.retryableCodes = retryableCodes;
      return this;
    }
    @Override
    public ServiceApiSettings.Builder<MethodId> setRetryParams(ImmutableMap<MethodId, RetryParams> retryParams) {
      this.retryParams = retryParams;
      return this;
    }
    @Override
    public ServiceApiSettings.Builder<MethodId> setExecutor(ScheduledExecutorService executor) {
      this.executor = executor;
      return this;
    }
    @Override
    public ServiceApiSettings.Builder<MethodId> setChannelProvider(ServiceApiSettings.ChannelProvider channelProvider) {
      this.channelProvider = channelProvider;
      return this;
    }
    @Override
    public ServiceApiSettings<MethodId> build() {
      String missing = "";
      if (retryableCodes == null) {
        missing += " retryableCodes";
      }
      if (retryParams == null) {
        missing += " retryParams";
      }
      if (executor == null) {
        missing += " executor";
      }
      if (channelProvider == null) {
        missing += " channelProvider";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ServiceApiSettings<MethodId>(
          this.retryableCodes,
          this.retryParams,
          this.executor,
          this.channelProvider);
    }
  }
}
