/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.HeaderInterceptor;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.auth.ClientAuthInterceptor;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public abstract class ServiceApiSettings {
    private final ChannelProvider channelProvider;
    private final ExecutorProvider executorProvider;
    private final String generatorName;
    private final String generatorVersion;
    private final String clientLibName;
    private final String clientLibVersion;

    protected ServiceApiSettings(ChannelProvider channelProvider, ExecutorProvider executorProvider, String generatorName, String generatorVersion, String clientLibName, String clientLibVersion) {
        this.channelProvider = channelProvider;
        this.executorProvider = executorProvider;
        this.clientLibName = clientLibName;
        this.clientLibVersion = clientLibVersion;
        this.generatorName = generatorName;
        this.generatorVersion = generatorVersion;
    }

    public final ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public final ExecutorProvider getExecutorProvider() {
        return this.executorProvider;
    }

    public static abstract class Builder {
        private static final int DEFAULT_EXECUTOR_THREADS = 4;
        private static final String DEFAULT_GENERATOR_NAME = "gapic";
        private static final String DEFAULT_CLIENT_LIB_NAME = "gax";
        private static final String DEFAULT_VERSION = "0.1.0";
        private String clientLibName = "gax";
        private String clientLibVersion = "0.1.0";
        private String serviceGeneratorName = "gapic";
        private String serviceGeneratorVersion = "0.1.0";
        private ChannelProvider channelProvider;
        private ExecutorProvider executorProvider = new ExecutorProvider(){

            @Override
            public ScheduledExecutorService getOrBuildExecutor() {
                return MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(4));
            }

            @Override
            public boolean shouldAutoClose() {
                return true;
            }
        };

        protected Builder(ConnectionSettings connectionSettings) {
            this();
            this.channelProvider = this.createChannelProvider(connectionSettings);
        }

        protected Builder(ServiceApiSettings settings) {
            this();
            this.channelProvider = settings.channelProvider;
            this.executorProvider = settings.executorProvider;
            this.clientLibName = settings.clientLibName;
            this.clientLibVersion = settings.clientLibVersion;
            this.serviceGeneratorName = settings.generatorName;
            this.serviceGeneratorVersion = settings.generatorVersion;
        }

        protected Builder() {
        }

        public Builder provideExecutorWith(final ScheduledExecutorService executor, final boolean shouldAutoClose) {
            this.executorProvider = new ExecutorProvider(){
                private volatile boolean executorProvided = false;

                @Override
                public ScheduledExecutorService getOrBuildExecutor() {
                    if (this.executorProvided) {
                        if (shouldAutoClose) {
                            throw new IllegalStateException("A fixed executor cannot be re-used when shouldAutoClose is set to true. Try calling provideExecutorWith with shouldAutoClose set to false or using the default executor.");
                        }
                    } else {
                        this.executorProvided = true;
                    }
                    return executor;
                }

                @Override
                public boolean shouldAutoClose() {
                    return shouldAutoClose;
                }
            };
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            this.channelProvider = this.createChannelProvider(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            this.channelProvider = this.createChannelProvider(settings);
            return this;
        }

        protected abstract ConnectionSettings.Builder getDefaultConnectionSettingsBuilder();

        public Builder provideChannelWith(Credentials credentials) {
            this.provideChannelWith(this.getDefaultConnectionSettingsBuilder().provideCredentialsWith(credentials).build());
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            this.provideChannelWith(this.getDefaultConnectionSettingsBuilder().provideCredentialsWith(scopes).build());
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            this.serviceGeneratorName = name;
            this.serviceGeneratorVersion = version;
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            this.clientLibName = name;
            this.clientLibVersion = version;
            return this;
        }

        public ChannelProvider getChannelProvider() {
            return this.channelProvider;
        }

        public ExecutorProvider getExecutorProvider() {
            return this.executorProvider;
        }

        public String getClientLibName() {
            return this.clientLibName;
        }

        public String getClientLibVersion() {
            return this.clientLibVersion;
        }

        public String getGeneratorName() {
            return this.serviceGeneratorName;
        }

        public String getGeneratorVersion() {
            return this.serviceGeneratorVersion;
        }

        protected Builder applyToAllApiMethods(Iterable<UnaryCallSettings.Builder> methodSettingsBuilders, UnaryCallSettings.Builder newSettingsBuilder) throws Exception {
            Set<Status.Code> newRetryableCodes = newSettingsBuilder.getRetryableCodes();
            RetrySettings.Builder newRetrySettingsBuilder = newSettingsBuilder.getRetrySettingsBuilder();
            for (UnaryCallSettings.Builder settingsBuilder : methodSettingsBuilders) {
                if (newRetryableCodes != null) {
                    settingsBuilder.setRetryableCodes(newRetryableCodes);
                }
                if (newRetrySettingsBuilder == null) continue;
                settingsBuilder.getRetrySettingsBuilder().merge(newRetrySettingsBuilder);
            }
            return this;
        }

        public abstract ServiceApiSettings build() throws IOException;

        private ChannelProvider createChannelProvider(final ConnectionSettings settings) {
            return new ChannelProvider(){

                @Override
                public ManagedChannel getOrBuildChannel(Executor executor) throws IOException {
                    ArrayList interceptors = Lists.newArrayList();
                    interceptors.add(new ClientAuthInterceptor(settings.getCredentials(), executor));
                    interceptors.add(new HeaderInterceptor(this.serviceHeader()));
                    return ((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)settings.getServiceAddress(), (int)settings.getPort()).negotiationType(NegotiationType.TLS).intercept((List)interceptors)).executor(executor)).build();
                }

                @Override
                public ConnectionSettings connectionSettings() {
                    return settings;
                }

                @Override
                public boolean shouldAutoClose() {
                    return true;
                }

                private String serviceHeader() {
                    String gaxVersion = ChannelProvider.class.getPackage().getImplementationVersion();
                    if (gaxVersion == null) {
                        gaxVersion = Builder.DEFAULT_VERSION;
                    }
                    String javaVersion = Runtime.class.getPackage().getImplementationVersion();
                    return String.format("%s/%s;%s/%s;gax/%s;java/%s", Builder.this.clientLibName, Builder.this.clientLibVersion, Builder.this.serviceGeneratorName, Builder.this.serviceGeneratorVersion, gaxVersion, javaVersion);
                }
            };
        }

        private ChannelProvider createChannelProvider(final ManagedChannel channel, final boolean shouldAutoClose) {
            return new ChannelProvider(){
                private boolean channelProvided = false;

                @Override
                public ManagedChannel getOrBuildChannel(Executor executor) {
                    if (this.channelProvided) {
                        if (shouldAutoClose) {
                            throw new IllegalStateException("A fixed channel cannot be re-used when shouldAutoClose is set to true. Try calling provideChannelWith with shouldAutoClose set to false, or using a channel created from a ConnectionSettings object.");
                        }
                    } else {
                        this.channelProvided = true;
                    }
                    return channel;
                }

                @Override
                public boolean shouldAutoClose() {
                    return shouldAutoClose;
                }

                @Override
                public ConnectionSettings connectionSettings() {
                    return null;
                }
            };
        }
    }
}

