/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ClientCallFactory;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;

class DirectStreamingCallable<RequestT, ResponseT> {
    private final ClientCallFactory<RequestT, ResponseT> factory;

    DirectStreamingCallable(ClientCallFactory<RequestT, ResponseT> factory) {
        Preconditions.checkNotNull(factory);
        this.factory = factory;
    }

    void serverStreamingCall(RequestT request, StreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        ClientCalls.asyncServerStreamingCall(call, request, responseObserver);
    }

    Iterator<ResponseT> blockingServerStreamingCall(RequestT request, CallContext context) {
        Preconditions.checkNotNull(request);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return ClientCalls.blockingServerStreamingCall(call, request);
    }

    StreamObserver<RequestT> bidiStreamingCall(StreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return ClientCalls.asyncBidiStreamingCall(call, responseObserver);
    }

    StreamObserver<RequestT> clientStreamingCall(StreamObserver<ResponseT> responseObserver, CallContext context) {
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = this.factory.newCall(context.getChannel(), context.getCallOptions());
        return ClientCalls.asyncClientStreamingCall(call, responseObserver);
    }
}

