/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ElementCounter;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public final class NumericThreshold<E>
implements BundlingThreshold<E> {
    private final long threshold;
    private final Long limit;
    private final ElementCounter<E> extractor;
    private long sum;

    public NumericThreshold(long threshold, @Nullable Long limit, ElementCounter<E> extractor) {
        this.threshold = threshold;
        this.limit = limit;
        this.extractor = (ElementCounter)Preconditions.checkNotNull(extractor);
        this.sum = 0L;
    }

    @Override
    public boolean canAccept(E e) {
        if (this.limit == null) {
            return true;
        }
        return this.sum + this.extractor.count(e) <= this.limit;
    }

    @Override
    public void accumulate(E e) {
        this.sum += this.extractor.count(e);
    }

    @Override
    public boolean isThresholdReached() {
        return this.sum >= this.threshold;
    }

    @Override
    public BundlingThreshold<E> copyWithZeroedValue() {
        return new NumericThreshold<E>(this.threshold, this.limit, this.extractor);
    }
}

