/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.ThresholdBundleHandle;
import com.google.api.gax.bundling.ThresholdBundleReceiver;
import com.google.api.gax.bundling.ThresholdBundler;
import java.util.ArrayList;
import java.util.List;

public final class ThresholdBundlingForwarder<T>
implements AutoCloseable {
    private final ThresholdBundler<T> bundler;
    private final ThresholdBundleReceiver<T> bundleReceiver;
    private final BundleForwardingRunnable forwardingRunnable;
    private final Thread forwarderThread;

    public ThresholdBundlingForwarder(ThresholdBundler<T> bundler, ThresholdBundleReceiver<T> bundleReceiver) {
        this.bundleReceiver = bundleReceiver;
        this.bundler = bundler;
        this.forwardingRunnable = new BundleForwardingRunnable();
        this.forwarderThread = new Thread(this.forwardingRunnable);
    }

    public void start() {
        this.forwarderThread.start();
    }

    public ThresholdBundleHandle addToNextBundle(T item) {
        this.bundleReceiver.validateItem(item);
        return this.bundler.add(item);
    }

    @Override
    public void close() {
        this.forwarderThread.interrupt();
        try {
            this.forwarderThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class BundleForwardingRunnable
    implements Runnable {
        private BundleForwardingRunnable() {
        }

        @Override
        public void run() {
            do {
                try {
                    this.processBundle(ThresholdBundlingForwarder.this.bundler.takeBundle());
                }
                catch (InterruptedException e) {
                    break;
                }
            } while (!Thread.currentThread().isInterrupted());
            ArrayList bundleData = new ArrayList();
            while (ThresholdBundlingForwarder.this.bundler.drainNextBundleTo(bundleData) > 0) {
                this.processBundle(bundleData);
                bundleData = new ArrayList();
            }
        }

        private void processBundle(List<T> bundle) {
            if (bundle.size() == 0) {
                return;
            }
            ThresholdBundlingForwarder.this.bundleReceiver.processBundle(bundle);
        }
    }
}

