/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ElementCounter;
import com.google.api.gax.bundling.ExternalThreshold;
import com.google.api.gax.bundling.NumericThreshold;
import com.google.api.gax.bundling.ThresholdBundler;
import com.google.api.gax.bundling.ThresholdBundlingForwarder;
import com.google.api.gax.grpc.BlockingCallThreshold;
import com.google.api.gax.grpc.BundleExecutor;
import com.google.api.gax.grpc.BundlingContext;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.BundlingSettings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class BundlerFactory<RequestT, ResponseT>
implements AutoCloseable {
    private final Map<String, ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>>> forwarders = new ConcurrentHashMap<String, ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>>>();
    private final BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor;
    private final BundlingSettings bundlingSettings;
    private final Object lock = new Object();

    public BundlerFactory(BundlingDescriptor<RequestT, ResponseT> bundlingDescriptor, BundlingSettings bundlingSettings) {
        this.bundlingDescriptor = bundlingDescriptor;
        this.bundlingSettings = bundlingSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>> getForwarder(String partitionKey) {
        ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>> forwarder = this.forwarders.get(partitionKey);
        if (forwarder == null) {
            Object object = this.lock;
            synchronized (object) {
                forwarder = this.forwarders.get(partitionKey);
                if (forwarder == null) {
                    forwarder = this.createForwarder(partitionKey);
                    this.forwarders.put(partitionKey, forwarder);
                    forwarder.start();
                }
            }
        }
        return forwarder;
    }

    BundlingSettings getBundlingSettings() {
        return this.bundlingSettings;
    }

    private ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>> createForwarder(String partitionKey) {
        ThresholdBundler<BundlingContext<RequestT, ResponseT>> bundler = ThresholdBundler.newBuilder().setThresholds(this.getThresholds(this.bundlingSettings)).setExternalThresholds((List<ExternalThreshold<BundlingContext<RequestT, ResponseT>>>)this.getExternalThresholds(this.bundlingSettings)).setMaxDelay(this.bundlingSettings.getDelayThreshold()).build();
        BundleExecutor<RequestT, ResponseT> processor = new BundleExecutor<RequestT, ResponseT>(this.bundlingDescriptor, partitionKey);
        return new ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>>(bundler, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            for (ThresholdBundlingForwarder<BundlingContext<RequestT, ResponseT>> forwarder : this.forwarders.values()) {
                forwarder.close();
            }
            this.forwarders.clear();
        }
    }

    private ImmutableList<BundlingThreshold<BundlingContext<RequestT, ResponseT>>> getThresholds(BundlingSettings bundlingSettings) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (bundlingSettings.getElementCountThreshold() != null) {
            ElementCounter elementCounter = new ElementCounter<BundlingContext<RequestT, ResponseT>>(){

                @Override
                public long count(BundlingContext<RequestT, ResponseT> bundlablePublish) {
                    return BundlerFactory.this.bundlingDescriptor.countElements(bundlablePublish.getRequest());
                }
            };
            Long elementCountLimit = null;
            if (bundlingSettings.getElementCountLimit() != null) {
                elementCountLimit = bundlingSettings.getElementCountLimit().longValue();
            }
            NumericThreshold countThreshold = new NumericThreshold(bundlingSettings.getElementCountThreshold().intValue(), elementCountLimit, elementCounter);
            listBuilder.add(countThreshold);
        }
        if (bundlingSettings.getRequestByteThreshold() != null) {
            ElementCounter requestByteCounter = new ElementCounter<BundlingContext<RequestT, ResponseT>>(){

                @Override
                public long count(BundlingContext<RequestT, ResponseT> bundlablePublish) {
                    return BundlerFactory.this.bundlingDescriptor.countBytes(bundlablePublish.getRequest());
                }
            };
            Long requestByteLimit = null;
            if (bundlingSettings.getRequestByteLimit() != null) {
                requestByteLimit = bundlingSettings.getRequestByteLimit().longValue();
            }
            NumericThreshold byteThreshold = new NumericThreshold(bundlingSettings.getRequestByteThreshold().intValue(), requestByteLimit, requestByteCounter);
            listBuilder.add(byteThreshold);
        }
        return listBuilder.build();
    }

    private ImmutableList<ExternalThreshold<BundlingContext<RequestT, ResponseT>>> getExternalThresholds(BundlingSettings bundlingSettings) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        Integer blockingCallCountThreshold = bundlingSettings.getBlockingCallCountThreshold();
        if (blockingCallCountThreshold == null) {
            blockingCallCountThreshold = 1;
        }
        if (blockingCallCountThreshold > 0) {
            BlockingCallThreshold blockingCallThreshold = new BlockingCallThreshold(blockingCallCountThreshold);
            listBuilder.add(blockingCallThreshold);
        }
        return listBuilder.build();
    }
}

