/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.AutoValue_FlowController_Settings;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.concurrent.Semaphore;
import javax.annotation.Nullable;

public class FlowController {
    @Nullable
    private final Semaphore outstandingElementCount;
    @Nullable
    private final Semaphore outstandingByteCount;
    private final boolean failOnLimits;
    private final Optional<Integer> maxOutstandingElementCount;
    private final Optional<Integer> maxOutstandingRequestBytes;

    public FlowController(Settings settings, boolean failOnFlowControlLimits) {
        this.maxOutstandingElementCount = settings.getMaxOutstandingElementCount();
        this.maxOutstandingRequestBytes = settings.getMaxOutstandingRequestBytes();
        this.outstandingElementCount = this.maxOutstandingElementCount.isPresent() ? new Semaphore((Integer)this.maxOutstandingElementCount.get()) : null;
        this.outstandingByteCount = this.maxOutstandingRequestBytes.isPresent() ? new Semaphore((Integer)this.maxOutstandingRequestBytes.get()) : null;
        this.failOnLimits = failOnFlowControlLimits;
    }

    public void reserve(int elements, int bytes) throws FlowControlException {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            if (!this.failOnLimits) {
                this.outstandingElementCount.acquireUninterruptibly(elements);
            } else if (!this.outstandingElementCount.tryAcquire(elements)) {
                throw new MaxOutstandingElementCountReachedException((Integer)this.maxOutstandingElementCount.get());
            }
        }
        if (this.outstandingByteCount != null) {
            int permitsToDraw = Math.min(bytes, (Integer)this.maxOutstandingRequestBytes.get());
            if (!this.failOnLimits) {
                this.outstandingByteCount.acquireUninterruptibly(permitsToDraw);
            } else if (!this.outstandingByteCount.tryAcquire(permitsToDraw)) {
                throw new MaxOutstandingRequestBytesReachedException((Integer)this.maxOutstandingRequestBytes.get());
            }
        }
    }

    public void release(int elements, int bytes) {
        Preconditions.checkArgument((elements > 0 ? 1 : 0) != 0);
        if (this.outstandingElementCount != null) {
            this.outstandingElementCount.release(elements);
        }
        if (this.outstandingByteCount != null) {
            int permitsToReturn = Math.min(bytes, (Integer)this.maxOutstandingRequestBytes.get());
            this.outstandingByteCount.release(permitsToReturn);
        }
    }

    public static abstract class Settings {
        public static Settings DEFAULT = Settings.newBuilder().setMaxOutstandingRequestBytes((Optional<Integer>)Optional.absent()).setMaxOutstandingElementCount((Optional<Integer>)Optional.absent()).build();

        public abstract Optional<Integer> getMaxOutstandingElementCount();

        public abstract Optional<Integer> getMaxOutstandingRequestBytes();

        public Builder toBuilder() {
            return new AutoValue_FlowController_Settings.Builder(this);
        }

        public static Builder newBuilder() {
            return new AutoValue_FlowController_Settings.Builder();
        }

        public static abstract class Builder {
            public abstract Builder setMaxOutstandingElementCount(Optional<Integer> var1);

            public abstract Builder setMaxOutstandingRequestBytes(Optional<Integer> var1);

            abstract Settings autoBuild();

            public Settings build() {
                Settings settings = this.autoBuild();
                Preconditions.checkArgument(((Integer)settings.getMaxOutstandingElementCount().or((Object)1) > 0 ? 1 : 0) != 0, (Object)"maxOutstandingElementCount limit is disabled by default, but if set it must be set to a value greater than 0.");
                Preconditions.checkArgument(((Integer)settings.getMaxOutstandingRequestBytes().or((Object)1) > 0 ? 1 : 0) != 0, (Object)"maxOutstandingRequestBytes limit is disabled by default, but if set it must be set to a value greater than 0.");
                return settings;
            }
        }
    }

    public static final class MaxOutstandingRequestBytesReachedException
    extends FlowControlException {
        private final int currentMaxBytes;

        public MaxOutstandingRequestBytesReachedException(int currentMaxBytes) {
            this.currentMaxBytes = currentMaxBytes;
        }

        public int getCurrentMaxBundleBytes() {
            return this.currentMaxBytes;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle bytes: %d have been reached.", this.currentMaxBytes);
        }
    }

    public static final class MaxOutstandingElementCountReachedException
    extends FlowControlException {
        private final int currentMaxElementCount;

        public MaxOutstandingElementCountReachedException(int currentMaxElementCount) {
            this.currentMaxElementCount = currentMaxElementCount;
        }

        public int getCurrentMaxBundleElementCount() {
            return this.currentMaxElementCount;
        }

        @Override
        public String toString() {
            return String.format("The maximum number of bundle elements: %d have been reached.", this.currentMaxElementCount);
        }
    }

    public static abstract class FlowControlException
    extends Exception {
        private FlowControlException() {
        }
    }
}

