/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ApiException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Status;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.joda.time.Duration;

public final class OperationFuture<ResponseT extends Message>
implements ListenableFuture<ResponseT> {
    private static final Duration POLLING_INTERVAL = Duration.standardSeconds((long)1L);
    private final ListenableFuture<Operation> initialOperationFuture;
    private final SettableFuture<ResponseT> finalResultFuture;
    private final Future<ResponseT> dataGetterFuture;
    private final CountDownLatch asyncCompletionLatch;

    public static <ResponseT extends Message> OperationFuture<ResponseT> create(OperationsClient operationsClient, ListenableFuture<Operation> initialOperationFuture, ScheduledExecutorService executor, Class<ResponseT> responseClass) {
        return OperationFuture.create(operationsClient, initialOperationFuture, executor, responseClass, POLLING_INTERVAL);
    }

    public static <ResponseT extends Message> OperationFuture<ResponseT> create(OperationsClient operationsClient, ListenableFuture<Operation> initialOperationFuture, ScheduledExecutorService executor, Class<ResponseT> responseClass, Duration pollingInterval) {
        return OperationFuture.create(operationsClient, initialOperationFuture, executor, responseClass, pollingInterval, new Waiter());
    }

    @VisibleForTesting
    static <ResponseT extends Message> OperationFuture<ResponseT> create(OperationsClient operationsClient, ListenableFuture<Operation> initialOperationFuture, ScheduledExecutorService executor, Class<ResponseT> responseClass, Duration pollingInterval, Waiter waiter) {
        SettableFuture finalResultFuture = SettableFuture.create();
        CountDownLatch asyncCompletionLatch = new CountDownLatch(1);
        Future<ResponseT> dataGetterFuture = executor.submit(new DataGetterRunnable<ResponseT>(initialOperationFuture, finalResultFuture, operationsClient, responseClass, pollingInterval, waiter, asyncCompletionLatch));
        OperationFuture<ResponseT> operationFuture = new OperationFuture<ResponseT>(initialOperationFuture, finalResultFuture, dataGetterFuture, asyncCompletionLatch);
        return operationFuture;
    }

    private OperationFuture(ListenableFuture<Operation> initialOperationFuture, SettableFuture<ResponseT> finalResultFuture, Future<ResponseT> dataGetterFuture, CountDownLatch asyncCompletionLatch) {
        this.initialOperationFuture = initialOperationFuture;
        this.finalResultFuture = finalResultFuture;
        this.dataGetterFuture = dataGetterFuture;
        this.asyncCompletionLatch = asyncCompletionLatch;
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.dataGetterFuture.cancel(mayInterruptIfRunning);
        return this.finalResultFuture.cancel(mayInterruptIfRunning);
    }

    public final ResponseT get() throws InterruptedException, ExecutionException {
        try {
            return (ResponseT)((Message)this.finalResultFuture.get());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ExecutionException) {
                throw (ExecutionException)e.getCause();
            }
            throw e;
        }
    }

    public final ResponseT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (ResponseT)((Message)this.finalResultFuture.get(timeout, unit));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ExecutionException) {
                throw (ExecutionException)e.getCause();
            }
            throw e;
        }
    }

    public final boolean isCancelled() {
        return this.finalResultFuture.isCancelled();
    }

    public final boolean isDone() {
        return this.finalResultFuture.isDone();
    }

    public final void addListener(Runnable listener, Executor executor) {
        this.finalResultFuture.addListener(listener, executor);
    }

    public final String getOperationName() throws InterruptedException, ExecutionException {
        return ((Operation)this.initialOperationFuture.get()).getName();
    }

    public final Any getMetadata() throws InterruptedException, ExecutionException {
        return ((Operation)this.initialOperationFuture.get()).getMetadata();
    }

    public final Operation getFirstOperationData() throws InterruptedException, ExecutionException {
        return (Operation)this.initialOperationFuture.get();
    }

    public final void awaitAsyncCompletion() throws InterruptedException {
        this.asyncCompletionLatch.await();
    }

    public final void awaitAsyncCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        this.asyncCompletionLatch.await(timeout, unit);
    }

    private static <ResponseT extends Message> void setResultFromOperation(SettableFuture<ResponseT> resultFuture, Operation operation, Class<ResponseT> responseClass) {
        Status status = Status.fromCodeValue((int)operation.getError().getCode());
        if (!status.equals((Object)Status.OK)) {
            String message = "Operation with name \"" + operation.getName() + "\" failed with status = " + status;
            resultFuture.setException((Throwable)new ApiException(message, null, status.getCode(), false));
        } else {
            Any responseAny = operation.getResponse();
            if (responseAny.is(responseClass)) {
                try {
                    Message response = responseAny.unpack(responseClass);
                    resultFuture.set((Object)response);
                }
                catch (InvalidProtocolBufferException e) {
                    String message = "Operation with name \"" + operation.getName() + "\" succeeded, but encountered a problem unpacking it.";
                    resultFuture.setException((Throwable)new ApiException(message, (Throwable)e, status.getCode(), false));
                }
            } else {
                String message = "Operation with name \"" + operation.getName() + "\" succeeded, but it is not the right type; expected \"" + responseClass.getName() + "\" but found \"" + responseAny.getTypeUrl() + "\"";
                resultFuture.setException((Throwable)new ClassCastException(message));
            }
        }
    }

    private static boolean isCancelled(Operation operation) {
        if (operation.getError() != null) {
            Status status = Status.fromCodeValue((int)operation.getError().getCode());
            return status.getCode().equals((Object)Status.Code.CANCELLED);
        }
        return false;
    }

    static class Waiter {
        Waiter() {
        }

        public void wait(Duration duration) throws InterruptedException {
            Thread.sleep(duration.getMillis());
        }
    }

    private static class DataGetterRunnable<ResponseT extends Message>
    implements Callable<ResponseT> {
        private final ListenableFuture<Operation> initialOperationFuture;
        private final SettableFuture<ResponseT> finalResultFuture;
        private final OperationsClient operationsClient;
        private final Class<ResponseT> responseClass;
        private final Duration pollingInterval;
        private final Waiter waiter;
        private final CountDownLatch asyncCompletionLatch;

        public DataGetterRunnable(ListenableFuture<Operation> initialOperationFuture, SettableFuture<ResponseT> finalResultFuture, OperationsClient operationsClient, Class<ResponseT> responseClass, Duration pollingInterval, Waiter waiter, CountDownLatch asyncCompletionLatch) {
            this.initialOperationFuture = initialOperationFuture;
            this.finalResultFuture = finalResultFuture;
            this.operationsClient = operationsClient;
            this.responseClass = responseClass;
            this.pollingInterval = pollingInterval;
            this.waiter = waiter;
            this.asyncCompletionLatch = asyncCompletionLatch;
        }

        @Override
        public ResponseT call() {
            try {
                this.callImpl();
            }
            finally {
                this.asyncCompletionLatch.countDown();
            }
            return null;
        }

        public void callImpl() {
            Operation latestOperation = null;
            try {
                latestOperation = (Operation)this.initialOperationFuture.get();
                if (latestOperation.getDone()) {
                    OperationFuture.setResultFromOperation(this.finalResultFuture, latestOperation, this.responseClass);
                    return;
                }
                do {
                    this.waiter.wait(this.pollingInterval);
                } while (!(latestOperation = this.operationsClient.getOperation(latestOperation.getName())).getDone());
                if (OperationFuture.isCancelled(latestOperation)) {
                    this.finalResultFuture.cancel(true);
                } else {
                    OperationFuture.setResultFromOperation(this.finalResultFuture, latestOperation, this.responseClass);
                }
                return;
            }
            catch (InterruptedException e) {
                try {
                    if (latestOperation != null) {
                        this.operationsClient.cancelOperation(latestOperation.getName());
                    }
                    if (!this.initialOperationFuture.isDone()) {
                        this.initialOperationFuture.cancel(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.finalResultFuture.cancel(true);
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable e) {
                this.finalResultFuture.setException(e);
                return;
            }
        }
    }
}

